/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.xri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.openxri.XRI;
import org.openxri.XRISegment;
import org.openxri.resolve.Resolver;

public class XRIAttributeUDIMetadata implements IAttributeUDIMetadata {

	private String attributeUDI;
	private Resolver resolver;
	private boolean https;
	private boolean saml;
	private boolean cid;
	private boolean refs;

	private XRIEntityUDIMetadata entityUDIMetadata;
	private String attributeID;

	XRIAttributeUDIMetadata(String attributeUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {

		this.attributeUDI = attributeUDI;
		this.resolver = resolver;
		this.https = https;
		this.saml = saml;
		this.cid = cid;
		this.refs = refs;

		this.entityUDIMetadata = null;
		this.attributeID = null;
	}

	private void resolve() throws IdASException {

		XRI xri = new XRI(this.attributeUDI);
		int splitIndex = xri.getXRIPath().getNumSegments() - 1;

		// split XRI Attribute UDI into Entity UDI and relative Attribute ID

		String entityUDI = xri.getAuthorityPath().toString();
		for (int i=0; i<splitIndex; i++) entityUDI += "/" + xri.getXRIPath().getSegmentAt(i).toString();

		this.entityUDIMetadata = new XRIEntityUDIMetadata(entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
		XRISegment segment = xri.getXRIPath().getSegmentAt(splitIndex);

		// if the relative Attribute ID is a cross-reference, get its value

		if (segment.getSubSegmentAt(0).getXRef() != null) {

			this.attributeID = segment.getSubSegmentAt(0).getXRef().toString();
			this.attributeID = this.attributeID.substring(1, this.attributeID.length() - 1);
		} else {

			this.attributeID = segment.toString();
		}

		// url decode the attribute ID
		
		try {

			this.attributeID = URLDecoder.decode(this.attributeID, "UTF-8");
		} catch (UnsupportedEncodingException ex) {

			throw new IdASException(ex);
		}
	}

	public IEntityUDIMetadata getEntityUDIMetadata() throws IdASException {

		if (this.entityUDIMetadata == null) this.resolve();

		return(this.entityUDIMetadata);
	}

	public URI getAttributeID() throws IdASException {

		if (this.attributeID == null) this.resolve();

		return(URI.create(this.attributeID));
	}
}
