/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.xri;

import java.util.List;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;

public class XRIContextUDIMetadata extends XRDSContextUDIMetadata {

	private String contextUDI;
	private Resolver resolver;
/*	private boolean https;
	private boolean saml;
	private boolean cid;
	private boolean refs;*/

	XRIContextUDIMetadata(String contextUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {

		this.contextUDI = contextUDI;
		this.resolver = resolver;
/*		this.https = https;
		this.saml = saml;
		this.cid = cid;
		this.refs = refs;*/
	}

	protected void resolve() throws IdASException {

		List selectedServices;

		try {

			XRI xri = new XRI(this.contextUDI);

			// FOR NEXT OPENXRI RELEASE
/*			ResolverFlags resolverFlags = new ResolverFlags();
			resolverFlags.setHttps(this.https);
			resolverFlags.setSaml(this.saml);
			resolverFlags.setCid(this.cid);
			resolverFlags.setRefs(this.refs);
			resolverFlags.setNoDefaultT(false);
			resolverFlags.setNoDefaultP(false);
			resolverFlags.setNoDefaultM(false);

			XRD xrd = this.resolver.resolveSEPToXRD(
					xri, 
					"$context", 
					null, 
					resolverFlags, 
					new ResolverState());*/

			// START OLD OPENXRI 1.0.1 RELEASE

			XRD xrd = this.resolver.resolveSEPToXRD(
					xri, 
					new TrustType(TrustType.TRUST_NONE), 
					"$context", 
					null, 
					true, 
					new ResolverState());
			
			// END OLD OPENXRI 1.0.1 RELEASE

			selectedServices = xrd.getSelectedServices().getList();

			if (selectedServices == null || selectedServices.size() < 1) throw new IdASException("No service endpoints selected.");
		} catch(IdASException ex) {

			throw ex;
		} catch(Exception ex) {

			throw new IdASException("Cannot resolve XRI " + contextUDI + ": " + ex.getMessage(), ex);
		}

		this.service = (Service) selectedServices.get(0);
	}
}
