/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.util;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import org.eclipse.higgins.idas.api.IdASException;

public class RDFXRDSUtil {

	public static final String MIME_RDF = "application/rdf+xml";
	public static final String MIME_XRDS = "application/xrds+xml";

	private RDFXRDSUtil() {

	}

	public static boolean probeRDF(String url) throws IdASException {

		try {

			URLConnection connection = new URL(url).openConnection();

			if (connection instanceof HttpURLConnection) {

				((HttpURLConnection) connection).setDoInput(true);
				((HttpURLConnection) connection).setDoOutput(true);
				((HttpURLConnection) connection).setRequestProperty("Accept", MIME_RDF);
				((HttpURLConnection) connection).setRequestMethod("HEAD");

				String contentType = ((HttpURLConnection) connection).getHeaderField("Content-Type");

				if (contentType.toLowerCase().indexOf(MIME_RDF) >= 0) {

					return(true);
				} else {

					return(false);
				}
			} else {

				if (url.toLowerCase().endsWith(".rdf")) {

					return(true);
				} else {

					return(false);
				}
			}
		} catch (Exception ex) {

			throw new IdASException("Cannot retrieve URL " + url + ": " + ex.getMessage(), ex);
		}
	}
}
