/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.xri;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IContextUDI;
import org.eclipse.higgins.idas.udi.IEntityUDI;
import org.eclipse.higgins.idas.udi.IUDIFactory;
import org.eclipse.higgins.idas.udi.impl.xri.XRIAttributeUDI;
import org.eclipse.higgins.idas.udi.impl.xri.XRIContextUDI;
import org.eclipse.higgins.idas.udi.impl.xri.XRIEntityUDI;
import org.openxri.resolve.Resolver;

public class XRIUDIFactory
implements IUDIFactory {
    static Pattern PATTERN_XREF = Pattern.compile("^.\\((.+)\\)$");
    private Resolver resolver;
    private boolean https;
    private boolean saml;
    private boolean cid;
    private boolean refs;

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        Map resolverSettings = (Map)mapComponentSettings.get("Resolver");
        Properties properties = new Properties();
        Iterator i = resolverSettings.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            properties.setProperty((String)key, (String)resolverSettings.get(key));
        }
        this.resolver = new Resolver();
        Map resolverFlagsSettings = (Map)mapComponentSettings.get("ResolverFlags");
        this.https = (Boolean)resolverFlagsSettings.get("https");
        this.saml = (Boolean)resolverFlagsSettings.get("saml");
        this.cid = (Boolean)resolverFlagsSettings.get("cid");
        this.refs = (Boolean)resolverFlagsSettings.get("refs");
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public IContextUDI parseContextUDI(String contextUDI) throws IdASException {
        if (!XRIContextUDI.canParse(contextUDI)) {
            return null;
        }
        return new XRIContextUDI(contextUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
    }

    public IEntityUDI parseEntityUDI(String entityUDI) throws IdASException {
        if (!XRIEntityUDI.canParse(entityUDI)) {
            return null;
        }
        return new XRIEntityUDI(entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
    }

    public IAttributeUDI parseAttributeUDI(String attributeUDI) throws IdASException {
        if (!XRIAttributeUDI.canParse(attributeUDI)) {
            return null;
        }
        return new XRIAttributeUDI(attributeUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
    }
}

