/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.util;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;

public abstract class XRDSContextUDIMetadata
implements IContextUDIMetadata {
    protected Service service;

    protected abstract void resolve() throws IdASException;

    public final String[] getTypes() throws IdASException {
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < this.service.getNumTypes(); ++i) {
            SEPType sepType = this.service.getTypeAt(i);
            if (sepType.getType() == null || sepType.getType().trim().equals("")) continue;
            types.add(sepType.getType());
        }
        return types.toArray(new String[types.size()]);
    }

    public final Map getConfiguration() throws IdASException {
        Map configuration;
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setSEP(this.service);
        try {
            handler.configure(null);
            configuration = handler.getSettings();
        }
        catch (Exception ex) {
            throw new IdASException("Cannot read configuration from XRDS service endpoint: ", (Throwable)ex);
        }
        return configuration;
    }
}

