/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.uri;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.uri.URIUDIFactory;
import org.eclipse.higgins.idas.udi.util.RDFXRDSUtil;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.eclipse.higgins.idas.udi.util.XRDSDownloader;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class URIEntityUDIMetadata
implements IEntityUDIMetadata {
    private String entityUDI;
    private IContextUDIMetadata contextUDIMetadata;
    private String entityID;

    URIEntityUDIMetadata(String entityUDI) {
        this.entityUDI = entityUDI;
        this.contextUDIMetadata = null;
        this.entityID = null;
    }

    private void resolve() throws IdASException {
        final String uri = this.entityUDI;
        boolean rdf = RDFXRDSUtil.probeRDF(uri);
        if (rdf) {
            this.contextUDIMetadata = new IContextUDIMetadata(){

                public String[] getTypes() throws IdASException {
                    return URIUDIFactory.TYPES_RDF;
                }

                public Map getConfiguration() throws IdASException {
                    HashMap configuration = new HashMap();
                    ArrayList<URI> uris = new ArrayList<URI>();
                    uris.add(URI.create(uri));
                    configuration.put("uris", uris);
                    return configuration;
                }
            };
            this.entityID = this.entityUDI;
        } else {
            this.contextUDIMetadata = new XRDSContextUDIMetadata(){

                protected void resolve() throws IdASException {
                    XRD xrd;
                    try {
                        URL url = new URL(URIEntityUDIMetadata.this.entityUDI);
                        xrd = XRDSDownloader.discoverXRDS(url).getFinalXRD();
                    }
                    catch (Exception ex) {
                        throw new IdASException("Cannot download XRDS from URL " + URIEntityUDIMetadata.this.entityUDI + ": " + ex.getMessage(), (Throwable)ex);
                    }
                    Resolver resolver = new Resolver();
                    int i = 0;
                    while (i < URIUDIFactory.SEP_TYPES.length) {
                        try {
                            XRDS xrds = new XRDS();
                            xrds = resolver.selectServiceFromXRD(xrd, new XRI("$"), new TrustType("none"), URIUDIFactory.SEP_TYPES[i], null, true, new ResolverState());
                            Vector services = xrds.getFinalXRD().getServices();
                            if (xrds.getFinalXRD().getStatusCode().equals("100") && services.size() > 0) {
                                this.service = (Service)services.get(0);
                                break;
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
            };
            this.entityID = this.entityUDI;
        }
    }

    public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
        if (this.contextUDIMetadata == null) {
            this.resolve();
        }
        return this.contextUDIMetadata;
    }

    public String getEntityID() throws IdASException {
        if (this.entityID == null) {
            this.resolve();
        }
        return this.entityID;
    }
}

