/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.xri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.xri.XRIEntityUDIMetadata;
import org.openxri.XRI;
import org.openxri.XRISegment;
import org.openxri.resolve.Resolver;

public class XRIAttributeUDIMetadata
implements IAttributeUDIMetadata {
    private String attributeUDI;
    private Resolver resolver;
    private boolean https;
    private boolean saml;
    private boolean cid;
    private boolean refs;
    private XRIEntityUDIMetadata entityUDIMetadata;
    private String attributeID;

    XRIAttributeUDIMetadata(String attributeUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {
        this.attributeUDI = attributeUDI;
        this.resolver = resolver;
        this.https = https;
        this.saml = saml;
        this.cid = cid;
        this.refs = refs;
        this.entityUDIMetadata = null;
        this.attributeID = null;
    }

    private void resolve() throws IdASException {
        XRI xri = new XRI(this.attributeUDI);
        int splitIndex = xri.getXRIPath().getNumSegments() - 1;
        String entityUDI = xri.getAuthorityPath().toString();
        int i = 0;
        while (i < splitIndex) {
            entityUDI = String.valueOf(entityUDI) + "/" + xri.getXRIPath().getSegmentAt(i).toString();
            ++i;
        }
        this.entityUDIMetadata = new XRIEntityUDIMetadata(entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
        XRISegment segment = xri.getXRIPath().getSegmentAt(splitIndex);
        if (segment.getSubSegmentAt(0).getXRef() != null) {
            this.attributeID = segment.getSubSegmentAt(0).getXRef().toString();
            this.attributeID = this.attributeID.substring(1, this.attributeID.length() - 1);
        } else {
            this.attributeID = segment.toString();
        }
        try {
            this.attributeID = URLDecoder.decode(this.attributeID, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IdASException((Throwable)ex);
        }
    }

    public IEntityUDIMetadata getEntityUDIMetadata() throws IdASException {
        if (this.entityUDIMetadata == null) {
            this.resolve();
        }
        return this.entityUDIMetadata;
    }

    public URI getAttributeID() throws IdASException {
        if (this.attributeID == null) {
            this.resolve();
        }
        return URI.create(this.attributeID);
    }
}

