/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.xri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.xri.XRIContextUDIMetadata;
import org.openxri.XRI;
import org.openxri.XRISegment;
import org.openxri.resolve.Resolver;

public class XRIEntityUDIMetadata
implements IEntityUDIMetadata {
    private String entityUDI;
    private Resolver resolver;
    private boolean https;
    private boolean saml;
    private boolean cid;
    private boolean refs;
    private IContextUDIMetadata contextUDIMetadata;
    private String entityID;

    XRIEntityUDIMetadata(String entityUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {
        this.entityUDI = entityUDI;
        this.resolver = resolver;
        this.https = https;
        this.saml = saml;
        this.cid = cid;
        this.refs = refs;
        this.contextUDIMetadata = null;
        this.entityID = null;
    }

    private void resolve() throws IdASException {
        XRI xri = new XRI(this.entityUDI);
        int splitIndex = -1;
        if (xri.getXRIPath().getNumSegments() > 1 && xri.getXRIPath().getSegmentAt(0).toString().equals("")) {
            splitIndex = 0;
        }
        if (xri.getXRIPath().getNumSegments() > 2 && xri.getXRIPath().getSegmentAt(1).toString().equals("")) {
            splitIndex = 1;
        }
        if (splitIndex != -1) {
            String contextUDI = xri.getAuthorityPath().toString();
            int i = 0;
            while (i < splitIndex) {
                contextUDI = String.valueOf(contextUDI) + "/" + xri.getXRIPath().getSegmentAt(i).toString();
                ++i;
            }
            this.contextUDIMetadata = new XRIContextUDIMetadata(contextUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
            XRISegment segment = xri.getXRIPath().getSegmentAt(splitIndex + 1);
            if (segment.getSubSegmentAt(0).getXRef() != null) {
                this.entityID = segment.getSubSegmentAt(0).getXRef().toString();
                this.entityID = this.entityID.substring(1, this.entityID.length() - 1);
            } else {
                this.entityID = segment.toString();
            }
            try {
                this.entityID = URLDecoder.decode(this.entityID, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IdASException((Throwable)ex);
            }
        } else {
            this.contextUDIMetadata = new XRIContextUDIMetadata(this.entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs);
            this.entityID = this.entityUDI;
        }
    }

    public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
        if (this.contextUDIMetadata == null) {
            this.resolve();
        }
        return this.contextUDIMetadata;
    }

    public String getEntityID() throws IdASException {
        if (this.entityID == null) {
            this.resolve();
        }
        return this.entityID;
    }
}

