/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.util;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.higgins.idas.api.IdASException;

public class RDFXRDSUtil {
    public static final String MIME_RDF = "application/rdf+xml";
    public static final String MIME_XRDS = "application/xrds+xml";

    private RDFXRDSUtil() {
    }

    public static boolean probeRDF(String url) throws IdASException {
        block4: {
            String contentType;
            block5: {
                try {
                    URLConnection connection = new URL(url).openConnection();
                    if (!(connection instanceof HttpURLConnection)) break block4;
                    ((HttpURLConnection)connection).setDoInput(true);
                    ((HttpURLConnection)connection).setDoOutput(true);
                    ((HttpURLConnection)connection).setRequestProperty("Accept", MIME_RDF);
                    ((HttpURLConnection)connection).setRequestMethod("HEAD");
                    ((HttpURLConnection)connection).connect();
                    contentType = ((HttpURLConnection)connection).getHeaderField("Content-Type");
                    if (contentType != null) break block5;
                    return false;
                }
                catch (Exception ex) {
                    throw new IdASException("Cannot retrieve URL " + url + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
            return contentType.toLowerCase().indexOf(MIME_RDF) >= 0;
        }
        return url.toLowerCase().endsWith(".rdf");
    }
}

