/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl;

import org.eclipse.higgins.idas.udi.IAttributeUDI;

public abstract class AbstractAttributeUDI implements IAttributeUDI {

	protected String attributeUDI;

	protected AbstractAttributeUDI(String attributeUDI) {

		this.attributeUDI = attributeUDI;
	}

	public boolean equals(Object other) {

		if (other == this) return(true);
		if (! (other instanceof AbstractAttributeUDI)) return(false);

		return(this.attributeUDI.equals(((AbstractAttributeUDI) other).attributeUDI));
	}

	public int hashCode() {
		
		return(this.attributeUDI.hashCode());
	}

	public String toString() {
		
		return(this.attributeUDI);
	}

	public int compareTo(Object other) {

		if (other == this) return(0);

		return(this.attributeUDI.compareTo(((AbstractAttributeUDI) other).attributeUDI));
	}
}
