/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.conf;

import java.util.regex.Pattern;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;

public class ConfEntityUDI extends AbstractEntityUDI {

	private static final long serialVersionUID = 5313091735647688652L;

	private static final Pattern PATTERN_SPLIT = Pattern.compile("(.+)(?<!\\\\)/(.+)");

	private String entityUDI;

	private IEntityUDIMetadata entityUDIMetadata;

	public ConfEntityUDI(String entityUDI) throws IdASException {

		super(entityUDI);

		this.entityUDI = entityUDI;

		this.entityUDIMetadata = null;
	}

	public IEntityUDIMetadata getEntityUDIMetadata() {

		if (this.entityUDIMetadata == null) this.entityUDIMetadata = new ConfEntityUDIMetadata(this.entityUDI);

		return(this.entityUDIMetadata);
	}

	static boolean canParse(String entityUDI) {

		if (! PATTERN_SPLIT.matcher(entityUDI).matches()) return(false);
		
		return(true);
	}
}