/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.conf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;

public class ConfEntityUDIMetadata implements IEntityUDIMetadata {

	private static final Pattern PATTERN_SPLIT = Pattern.compile("(.+)(?<!\\\\)/(.+)");
	
	private String entityUDI;

	private IContextUDIMetadata contextUDIMetadata;
	private String entityID;

	ConfEntityUDIMetadata(String entityUDI) {

		this.entityUDI = entityUDI;

		this.contextUDIMetadata = null;
		this.entityID = null;
	}

	private void resolve() throws IdASException {

		// split the entity UDI at the '/' character

		Matcher matcher = PATTERN_SPLIT.matcher(this.entityUDI);
		
		if (matcher.matches()) {

			// split Configuration Entity UDI into Context UDI and relative Entity ID

			String contextUDI = matcher.group(1).replaceAll("\\/", "/");

			this.contextUDIMetadata = new ConfContextUDIMetadata(contextUDI);
			this.entityID = matcher.group(2).replaceAll("\\/", "/");
		} else {

			this.contextUDIMetadata = new ConfContextUDIMetadata(this.entityUDI);
			this.entityID = this.entityUDI;
		}
	}

	public IContextUDIMetadata getContextUDIMetadata() throws IdASException {

		if (this.contextUDIMetadata == null) this.resolve();

		return(this.contextUDIMetadata);
	}

	public String getEntityID() throws IdASException {

		if (this.entityID == null) this.resolve();

		return(this.entityID);
	}
}
