/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.conf;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IContextUDI;
import org.eclipse.higgins.idas.udi.IEntityUDI;
import org.eclipse.higgins.idas.udi.IUDIFactory;

public class ConfUDIFactory implements IUDIFactory {

	public ConfUDIFactory() {
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {

	}

	public ISettingDescriptor getComponentDescriptor() {

		return(null);
	}

	public IContextUDI parseContextUDI(String contextUDI) throws IdASException {

		if (! ConfContextUDI.canParse(contextUDI)) return(null);

		return(new ConfContextUDI(contextUDI));
	}

	public IEntityUDI parseEntityUDI(String entityUDI) throws IdASException {

		if (! ConfEntityUDI.canParse(entityUDI)) return(null);

		return(new ConfEntityUDI(entityUDI));
	}

	public IAttributeUDI parseAttributeUDI(String attributeUDI) throws IdASException {

		return(null);
	}
}
