/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.uri;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractContextUDI;

public class URIContextUDI extends AbstractContextUDI {

	private static final long serialVersionUID = 6356129637679077736L;

	private IContextUDIMetadata contextUDIMetadata;

	public URIContextUDI(String contextUDI) throws IdASException {

		super(contextUDI);

		this.contextUDIMetadata = null;
	}

	public IContextUDIMetadata getContextUDIMetadata() {

		if (this.contextUDIMetadata == null) this.contextUDIMetadata = new URIContextUDIMetadata(this.contextUDI);

		return(this.contextUDIMetadata);
	}

	static boolean canParse(String contextUDI) {

		URI uri;

		try {

			uri = new URI(contextUDI);
		} catch (URISyntaxException ex) {

			return(false);
		}

		if (uri.getScheme() == null) return(false);
		if (uri.getFragment() != null) return(false);

		return(true);
	}

}