/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.xri;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;
import org.openxri.resolve.Resolver;

public class XRIEntityUDI extends AbstractEntityUDI {

	private static final long serialVersionUID = 5313091735647688652L;

	private String entityUDI;
	private Resolver resolver;
	private boolean https;
	private boolean saml;
	private boolean cid;
	private boolean refs;

	private IEntityUDIMetadata entityUDIMetadata;

	public XRIEntityUDI(String entityUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) throws IdASException {

		super(entityUDI);

		this.entityUDI = entityUDI;
		this.resolver = resolver;
		this.https = https;
		this.saml = saml;
		this.cid = cid;
		this.refs = refs;

		this.entityUDIMetadata = null;
	}

	public IEntityUDIMetadata getEntityUDIMetadata() {

		if (this.entityUDIMetadata == null) this.entityUDIMetadata = new XRIEntityUDIMetadata(this.entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs);

		return(this.entityUDIMetadata);
	}

	static boolean canParse(String entityUDI) {

		if (! entityUDI.startsWith("xri://") &&
				! entityUDI.startsWith("=") &&
				! entityUDI.startsWith("@") &&
				! entityUDI.startsWith("+") &&
				! entityUDI.startsWith("$")) return(false);

		return(true);
	}
}