/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.xri;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IContextUDI;
import org.eclipse.higgins.idas.udi.IEntityUDI;
import org.eclipse.higgins.idas.udi.IUDIFactory;
import org.openxri.resolve.Resolver;

public class XRIUDIFactory implements IUDIFactory {

	static Pattern PATTERN_XREF = Pattern.compile("^.\\((.+)\\)$");

	private Resolver resolver;
	private boolean https;
	private boolean saml;
	private boolean cid;
	private boolean refs;

	public XRIUDIFactory() {

	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {

		Map resolverSettings = (Map) mapComponentSettings.get("Resolver");

		Properties properties = new Properties();
		for (Iterator i = resolverSettings.keySet().iterator(); i.hasNext(); ) {

			Object key = i.next();
			properties.setProperty((String) key, (String) resolverSettings.get(key));
		}

		// FOR NEXT OPENXRI RELEASE
		//this.resolver = new Resolver(properties);
		this.resolver = new Resolver();

		Map resolverFlagsSettings = (Map) mapComponentSettings.get("ResolverFlags");

		this.https = ((Boolean) resolverFlagsSettings.get("https")).booleanValue();
		this.saml = ((Boolean) resolverFlagsSettings.get("saml")).booleanValue();
		this.cid = ((Boolean) resolverFlagsSettings.get("cid")).booleanValue();
		this.refs = ((Boolean) resolverFlagsSettings.get("refs")).booleanValue();
	}

	public ISettingDescriptor getComponentDescriptor() {

		return(null);
	}

	public IContextUDI parseContextUDI(String contextUDI) throws IdASException {

		if (! XRIContextUDI.canParse(contextUDI)) return(null);

		return(new XRIContextUDI(contextUDI, this.resolver, this.https, this.saml, this.cid, this.refs));
	}

	public IEntityUDI parseEntityUDI(String entityUDI) throws IdASException {

		if (! XRIEntityUDI.canParse(entityUDI)) return(null);

		return(new XRIEntityUDI(entityUDI, this.resolver, this.https, this.saml, this.cid, this.refs));
	}

	public IAttributeUDI parseAttributeUDI(String attributeUDI) throws IdASException {

		if (! XRIAttributeUDI.canParse(attributeUDI)) return(null);

		return(new XRIAttributeUDI(attributeUDI, this.resolver, this.https, this.saml, this.cid, this.refs));
	}
}
