/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;

public abstract class XRDSContextUDIMetadata implements IContextUDIMetadata {

	protected Service service;

	public XRDSContextUDIMetadata() {

	}

	protected abstract void resolve() throws IdASException;

	public final String[] getTypes() throws IdASException {

		if (this.service == null) this.resolve();
		if (this.service == null) throw new IdASException("No service endpoint selected.");

		List types = new ArrayList();

		for (int i=0; i<this.service.getNumTypes(); i++) {

			SEPType sepType = this.service.getTypeAt(i);
			if (sepType.getType() == null || sepType.getType().trim().equals("")) continue;
			types.add(sepType.getType());
		}

		return((String[]) types.toArray(new String[types.size()]));
	}

	public final Map getConfiguration() throws IdASException {

		if (this.service == null) this.resolve();
		if (this.service == null) throw new IdASException("No service endpoint selected.");

		Map configuration;

		ConfigurationHandler handler = new ConfigurationHandler();
		handler.setSEP(this.service);

		try {

			handler.configure(null);
			configuration = handler.getSettings();
		} catch (Exception ex) {

			throw new IdASException("Cannot read configuration from XRDS service endpoint: ", ex);
		}

		return(configuration);
	}
}
