/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.iss.cardspace.CardspaceDisplayMappings;

public class CardSpacePolicy
implements ICardSpacePolicy {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$CardSpacePolicy == null ? (class$org$eclipse$higgins$iss$cardspace$CardSpacePolicy = CardSpacePolicy.class$("org.eclipse.higgins.iss.cardspace.CardSpacePolicy")) : class$org$eclipse$higgins$iss$cardspace$CardSpacePolicy));
    protected String issuer = "";
    protected String issuerPolicy = "";
    protected String tokenType = "";
    protected List requiredClaims = new ArrayList();
    protected List optionalClaims = new ArrayList();
    protected URL site = null;
    protected String privacyUrl = "";
    protected String privacyVersion = "";
    protected Class[] cardTypes = new Class[]{class$org$eclipse$higgins$icard$IInformationCard == null ? (class$org$eclipse$higgins$icard$IInformationCard = CardSpacePolicy.class$("org.eclipse.higgins.icard.IInformationCard")) : class$org$eclipse$higgins$icard$IInformationCard};
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$CardSpacePolicy;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IInformationCard;

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public List getRequiredClaims() {
        return Collections.unmodifiableList(this.requiredClaims);
    }

    public List getOptionalClaims() {
        return Collections.unmodifiableList(this.optionalClaims);
    }

    public URL getSite() {
        return this.site;
    }

    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    public String getPrivacyVersion() {
        return this.privacyVersion;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setIssuerPolicy(String issuerPolicy) {
        this.issuerPolicy = issuerPolicy;
    }

    public void setOptionalClaims(List optionalClaims) {
        this.optionalClaims = optionalClaims;
    }

    public void setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    public void setPrivacyVersion(String privacyVersion) {
        this.privacyVersion = privacyVersion;
    }

    public void setRequiredClaims(List requiredClaims) {
        this.requiredClaims = requiredClaims;
    }

    public void setSite(URL site) {
        this.site = site;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getType() {
        return "cardspace_type";
    }

    public Class[] getICardTypes() {
        return this.cardTypes;
    }

    public boolean isSatisfiedBy(ICard icard) {
        if (icard == null) {
            return false;
        }
        if (icard instanceof IInformationCard) {
            return this.isSatisfiedBy((IInformationCard)icard);
        }
        return false;
    }

    public boolean isSatisfiedBy(IInformationCard icard) {
        log.trace((Object)("CardSpacePolicy::isSatisfiedBy check on [" + icard.getName() + "]"));
        if (!this.issuer.equals("") && !this.issuer.equals(icard.getIssuer())) {
            log.trace((Object)("issuer " + this.issuer + " does not match " + icard.getIssuer()));
            return false;
        }
        log.trace((Object)"issuer ok.");
        List suppTokenTypes = icard.getSupportedTokenTypes();
        log.trace((Object)("Supported token types: " + suppTokenTypes));
        if (suppTokenTypes == null || !suppTokenTypes.contains(this.tokenType)) {
            log.trace((Object)("Token type: " + this.tokenType + " is not supported."));
        }
        List suppClaims = icard.getSupportedClaimTypesUris();
        log.trace((Object)("supported claims: " + suppClaims));
        for (int i = 0; i < this.requiredClaims.size(); ++i) {
            String claim = (String)this.requiredClaims.get(i);
            log.trace((Object)("Claim to satisfy: " + claim));
            if (suppClaims.contains(claim)) continue;
            log.trace((Object)("claim not satisfied: " + claim));
            log.trace((Object)"returning FALSE");
            return false;
        }
        log.trace((Object)"returning TRUE");
        return true;
    }

    public String[] getSummary() {
        return this.makeSummary(this.requiredClaims);
    }

    public String[] makeSummary(List claims) {
        String[] summary = new String[claims.size()];
        ListIterator li = claims.listIterator();
        int i = 0;
        while (li.hasNext()) {
            String cl = CardspaceDisplayMappings.getString(li.next().toString());
            summary[i++] = cl;
        }
        return summary;
    }

    public String[] getOptionalClaimSummary() {
        return this.makeSummary(this.optionalClaims);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

