/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PPIDHelper;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.UserChoiceTree_OR;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.iss.cardspace.PPIDCardSpacePolicy;
import org.eclipse.higgins.iss.cardspace.STSFaultException;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class CardSpaceSelector
implements IICardSelector {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector == null ? (class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector = CardSpaceSelector.class$("org.eclipse.higgins.iss.cardspace.CardSpaceSelector")) : class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector));
    static String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    protected ICardSpacePolicy policy;
    protected CallbackHandler handler;
    protected ICardRegistry registry = ICardRegistry.getInstance();
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$api$IElement;

    public CardSpaceSelector(CallbackHandler handler, ICardSpacePolicy policy) {
        this.handler = handler;
        this.policy = policy;
    }

    public IPolicy getPolicy() {
        return this.policy;
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public UserChoiceTree getUserChoice() throws Exception {
        log.info((Object)"CardSpaceICardSelector::getUserChoice()");
        log.info((Object)("policy: " + this.policy));
        ArrayList<UserChoiceTree_OR> list = new ArrayList<UserChoiceTree_OR>();
        ArrayList<CredentialContainer> l = new ArrayList<CredentialContainer>();
        Class[] iCardTypes = this.policy.getICardTypes();
        Iterator itr = this.registry.getICardProviders();
        while (itr.hasNext()) {
            ICardProvider p = (ICardProvider)itr.next();
            boolean hasRequiredTypes = false;
            for (int i = 0; i < iCardTypes.length; ++i) {
                Class[] supportedTypes = p.getSupportedTypes();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    if (!iCardTypes[i].isAssignableFrom(supportedTypes[j])) continue;
                    hasRequiredTypes = true;
                    break;
                }
                if (hasRequiredTypes) break;
            }
            if (!hasRequiredTypes) continue;
            try {
                Iterator cards = p.getICards(this.handler, (IPolicy)this.policy);
                while (cards.hasNext()) {
                    ICard card = (ICard)cards.next();
                    CredentialContainer cc = new CredentialContainer(card, card.getCUID().toString());
                    l.add(cc);
                }
            }
            catch (Exception e) {
                log.error((Object)"CardSpaceICardSelector::getUserChoice()", (Throwable)e);
            }
            if (l.size() <= 0) continue;
            UCTelm elm = new UCTelm((IPolicy)this.policy, l);
            list.add(new UserChoiceTree_OR(elm));
        }
        UserChoiceTree_ANDofORs res = new UserChoiceTree_ANDofORs(list);
        return res;
    }

    public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws STSFaultException, Exception {
        SelectionANDofORsElm elm = (SelectionANDofORsElm)selection.getElements().get(0);
        String uid = elm.getUUID();
        IInformationCard infocard = (IInformationCard)this.registry.getICardByCUID(this.handler, uid);
        URI uriRP = null;
        try {
            uriRP = URI.create(XMLHelper.escapedString((String)selection.action));
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean selfIssued = infocard.isSelfIssued();
        ConfigurationHandler ch = this.getConfigurationHandler(selfIssued);
        Map mapGlobalSettings = ch.getSettings();
        IBase64Extension base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
        Constants constants = new Constants();
        TokenRequestFactory factoryRequest = new TokenRequestFactory();
        STSResponse stsResponse = new STSResponse();
        ISTSRequest stsRequest = null;
        IElement elemClaims = this.makeClaims(this.policy, infocard, selection, base64Extension);
        log.info((Object)("@@@@@@@@@ X509 CERT is " + selection.sslCert));
        if (infocard instanceof IManagedInformationCard) {
            IManagedInformationCard managed = (IManagedInformationCard)infocard;
            ISecurityTokenService stsManaged = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceClient");
            ISecurityTokenService stsBinding = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceBinding");
            ICredential credential = selection.getCredential();
            URI uriTokenService = null;
            URI uriMetadataService = null;
            X509Certificate endpointCert = null;
            if (!(credential instanceof ITokenServiceCredential)) {
                throw new IllegalArgumentException();
            }
            ITokenServiceCredential tsc = (ITokenServiceCredential)credential;
            uriTokenService = tsc.getAddress();
            endpointCert = tsc.getCertificate();
            uriMetadataService = tsc.getMetadataAddress();
            if (credential instanceof ISelfIssuedCredential) {
                ISelfIssuedCredential sic = (ISelfIssuedCredential)credential;
                log.info((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.info((Object)"Create request for managed card with self issued saml as authentification");
                String ppid = sic.getPPID();
                byte[] bppid = base64Extension.decode(ppid);
                log.info((Object)("CERT is " + endpointCert));
                PPIDCardSpacePolicy ppp = new PPIDCardSpacePolicy(endpointCert, bppid);
                CardSpaceSelector subselector = new CardSpaceSelector(this.handler, ppp);
                UserChoiceTree_ANDofORs uct = (UserChoiceTree_ANDofORs)subselector.getUserChoice();
                SelectionANDofORs subselection = uct.getDefaultSelection();
                if (subselection.isEmpty()) {
                    throw new Exception("Cannot find the Personal card used to authenticate for this managed card.");
                }
                subselection.action = infocard.getIssuer();
                subselection.sslCert = endpointCert;
                IIdentityToken subtok = subselector.getIdentityToken(subselection);
                log.info((Object)("\n\n\n SSS AUTH: " + subtok.getAs(class$java$lang$String == null ? (class$java$lang$String = CardSpaceSelector.class$("java.lang.String")) : class$java$lang$String) + "\n\n\n"));
                stsRequest = factoryRequest.createManagedRequest(uriRP, new X509Certificate[]{selection.sslCert}, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, (IElement)subtok.getAs(class$org$eclipse$higgins$sts$api$IElement == null ? (class$org$eclipse$higgins$sts$api$IElement = CardSpaceSelector.class$("org.eclipse.higgins.sts.api.IElement")) : class$org$eclipse$higgins$sts$api$IElement), base64Extension);
                log.info((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.info((Object)"create request for managed card with self issued saml as authentification done ");
            } else if (credential instanceof IUsernamePasswordCredential) {
                IUsernamePasswordCredential unpc = (IUsernamePasswordCredential)credential;
                log.info((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.info((Object)"Create request for managed card with username/password as authentification");
                stsRequest = factoryRequest.createManagedRequest(uriRP, new X509Certificate[]{selection.sslCert}, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, unpc.getUsername(), unpc.getPassword(), base64Extension);
                log.info((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ");
                log.info((Object)"create request for managed card with username/password as authentification done");
            } else {
                throw new Exception("Unsupported user credential " + credential);
            }
            mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
            stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null);
            log.info((Object)"Invoke STS for managed card.");
            stsManaged.invoke(mapGlobalSettings, null, null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
            log.info((Object)"%%%% END OF MANAGED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% done ");
        } else if (infocard instanceof IPersonalInformationCard) {
            IPersonalInformationCard pesonal = (IPersonalInformationCard)infocard;
            ISecurityTokenService stsPersonal = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
            log.info((Object)"Create request for self signed card");
            stsRequest = factoryRequest.createPersonalRequest(uriRP, new X509Certificate[]{selection.sslCert}, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, base64Extension);
            log.info((Object)"Invoke STS for self signed card.");
            stsPersonal.invoke(mapGlobalSettings, "SecurityTokenService", null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
        }
        if (null != stsResponse.getFault()) {
            log.error((Object)("Returning STS Fault: " + stsResponse.getFault().getDetail()));
            throw new STSFaultException(stsResponse.getFault());
        }
        String encodedSSL = base64Extension.encode(selection.sslCert.getEncoded());
        return new IdentityToken((ISTSResponse)stsResponse, encodedSSL);
    }

    private IElement makeClaims(ICardSpacePolicy pol, IInformationCard infocard, SelectionANDofORs selection, IBase64Extension base64Extension) throws Exception {
        Element elemClaims = new Element();
        String begin = "<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">";
        String end = "</wst:Claims>";
        StringBuffer middle = new StringBuffer();
        X509Certificate rp = selection.sslCert;
        List requiredClaims = pol.getRequiredClaims();
        this.makeClaimTags(requiredClaims, middle, infocard, rp, base64Extension);
        if (selection.optionalClaims) {
            List optionalClaims = pol.getOptionalClaims();
            this.makeClaimTags(optionalClaims, middle, infocard, rp, base64Extension);
        }
        elemClaims.set((Object)(begin + middle + end));
        return elemClaims;
    }

    public void makeClaimTags(List claims, StringBuffer middle, IInformationCard infocard, X509Certificate rp, IBase64Extension base64Extension) {
        boolean selfIssued = infocard.isSelfIssued();
        for (int i = 0; i < claims.size(); ++i) {
            String claim = (String)claims.get(i);
            if (selfIssued) {
                try {
                    ISimpleClaim sc;
                    List l;
                    if (PPID_CLAIM.equalsIgnoreCase(claim)) {
                        byte[] ppid = PPIDHelper.computeClaimValuePPID((IInformationCard)infocard, (X509Certificate)rp);
                        String sppid = base64Extension.encode(ppid);
                        middle.append("<ic:ClaimType Uri=\"").append(claim).append("\">").append(sppid).append("</ic:ClaimType>");
                        continue;
                    }
                    IClaim c = infocard.getClaim(claim);
                    String val = null;
                    if (c instanceof ISimpleClaim && (l = (sc = (ISimpleClaim)c).getValues()).size() > 0) {
                        val = (String)l.get(0);
                    }
                    if (val == null) continue;
                    middle.append("<ic:ClaimType Uri=\"").append(claim).append("\">").append(val).append("</ic:ClaimType>");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            middle.append("<ic:ClaimType Uri=\"" + claim + "\"/>");
        }
    }

    public ConfigurationHandler getConfigurationHandler(boolean selfIssued) throws Exception {
        String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        if (null == strConfigurationBase) {
            throw new Exception("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
        }
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        configurationHandler.setConfigurationBase(strConfigurationBase);
        configurationHandler.setFileName("ClientConfiguration.xml");
        if (!configurationHandler.configure(null)) {
            log.error((Object)"Not Initialized!");
            throw new Exception("CardspaceSelector: cannot initialize configHandler");
        }
        return configurationHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

