/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.UserChoiceTree_OR;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.iss.cardspace.util.STSHelper;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;

public class CardSpaceSelector2
implements IICardSelector {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2 == null ? (class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2 = CardSpaceSelector2.class$("org.eclipse.higgins.iss.cardspace.CardSpaceSelector2")) : class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2));
    protected ICardSpacePolicy policy;
    protected CallbackHandler handler;
    protected String stsConfigurationBase;
    protected ICardRegistry registry = ICardRegistry.getInstance();
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2;

    public CardSpaceSelector2(String stsConfigurationBase, CallbackHandler handler, ICardSpacePolicy policy) {
        this.handler = handler;
        this.policy = policy;
        this.stsConfigurationBase = stsConfigurationBase;
    }

    public IPolicy getPolicy() {
        return this.policy;
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public UserChoiceTree getUserChoice() throws Exception {
        log.info((Object)"CardSpaceICardSelector::getUserChoice()");
        log.info((Object)("policy: " + this.policy));
        ArrayList<UserChoiceTree_OR> list = new ArrayList<UserChoiceTree_OR>();
        ArrayList<CredentialContainer> l = new ArrayList<CredentialContainer>();
        Class[] iCardTypes = this.policy.getICardTypes();
        Iterator itr = this.registry.getICardProviders();
        while (itr.hasNext()) {
            ICardProvider p = (ICardProvider)itr.next();
            boolean hasRequiredTypes = false;
            for (int i = 0; i < iCardTypes.length; ++i) {
                Class[] supportedTypes = p.getSupportedTypes();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    if (!iCardTypes[i].isAssignableFrom(supportedTypes[j])) continue;
                    hasRequiredTypes = true;
                    break;
                }
                if (hasRequiredTypes) break;
            }
            if (!hasRequiredTypes) continue;
            try {
                Iterator cards = p.getICards(this.handler, (IPolicy)this.policy);
                while (cards.hasNext()) {
                    ICard card = (ICard)cards.next();
                    CredentialContainer cc = new CredentialContainer(card, card.getCUID().toString());
                    l.add(cc);
                }
            }
            catch (Exception e) {
                log.error((Object)"CardSpaceICardSelector::getUserChoice()", (Throwable)e);
            }
        }
        if (l.size() > 0) {
            UCTelm elm = new UCTelm((IPolicy)this.policy, l);
            list.add(new UserChoiceTree_OR(elm));
        }
        UserChoiceTree_ANDofORs res = new UserChoiceTree_ANDofORs(list);
        return res;
    }

    public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws Exception {
        String credential_db_uri = selection.cardspace_credential_db_uri;
        SelectionANDofORsElm elm = (SelectionANDofORsElm)selection.getElements().get(0);
        String uid = elm.getUUID();
        ConfigurationHandler ch = this.getConfigurationHandler(false);
        Map mapGlobalSettings = ch.getSettings();
        IBase64Extension base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
        IInformationCard infocard = (IInformationCard)this.registry.getICardByCUID(this.handler, uid);
        STSHelper stsHelper = new STSHelper(this.stsConfigurationBase, infocard, this.policy, selection.username, selection.password);
        stsHelper.setX509Certificate(selection.sslCert);
        ISTSResponse response = stsHelper.getToken();
        System.out.println("\t====>>>> Site SSL Sertificate: [[" + selection.sslCert + "]]");
        return new IdentityToken(response, selection.sslCert == null ? null : base64Extension.encode(selection.sslCert.getEncoded()));
    }

    public ConfigurationHandler getConfigurationHandler(boolean selfIssued) throws Exception {
        String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        if (null == strConfigurationBase) {
            throw new Exception("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
        }
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        configurationHandler.setConfigurationBase(strConfigurationBase);
        configurationHandler.setFileName("ClientConfiguration.xml");
        if (!configurationHandler.configure(null)) {
            log.error((Object)"Not Initialized!");
            throw new Exception("CardspaceSelector: cannot initialize configHandler");
        }
        return configurationHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

