/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.cardspace.CardSpacePolicy;

public class CardSpacePolicyHelper {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$util$CardSpacePolicyHelper == null ? (class$org$eclipse$higgins$iss$cardspace$util$CardSpacePolicyHelper = CardSpacePolicyHelper.class$("org.eclipse.higgins.iss.cardspace.util.CardSpacePolicyHelper")) : class$org$eclipse$higgins$iss$cardspace$util$CardSpacePolicyHelper));
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$util$CardSpacePolicyHelper;

    public static CardSpacePolicy fromAxiom(OMElement om) throws PolicyParseException {
        CardSpacePolicy pol = new CardSpacePolicy();
        ArrayList<String> requiredClaims = new ArrayList<String>();
        ArrayList<String> optionalClaims = new ArrayList<String>();
        String top = om.getLocalName();
        if (top.equalsIgnoreCase("OBJECT")) {
            Iterator iter = om.getChildrenWithName(new QName("PARAM"));
            while (iter.hasNext()) {
                int i;
                String[] claims_split;
                OMElement om_elm = (OMElement)iter.next();
                log.trace((Object)om_elm);
                String name = om_elm.getAttributeValue(new QName("name"));
                String value = om_elm.getAttributeValue(new QName("value"));
                if (name == null || value == null) {
                    throw new PolicyParseException("policy xml has not correct format");
                }
                if (name.equals("tokenType")) {
                    pol.setTokenType(value);
                    continue;
                }
                if (name.equals("requiredClaims")) {
                    claims_split = value.split("\\s+");
                    for (i = 0; i < claims_split.length; ++i) {
                        if (claims_split[i].length() <= 0) continue;
                        log.trace((Object)("Adding claim <" + claims_split[i] + ">"));
                        requiredClaims.add(claims_split[i]);
                    }
                    continue;
                }
                if (name.equals("optionalClaims")) {
                    claims_split = value.split("\\s+");
                    for (i = 0; i < claims_split.length; ++i) {
                        if (claims_split[i].length() <= 0) continue;
                        log.trace((Object)("Adding optional claim <" + claims_split[i] + ">"));
                        optionalClaims.add(claims_split[i]);
                    }
                    continue;
                }
                if (name.equals("issuer")) {
                    pol.setIssuer(value);
                    continue;
                }
                if (name.equals("issuerPolicy")) {
                    pol.setIssuerPolicy(value);
                    continue;
                }
                if (name.equals("privacyUrl")) {
                    pol.setPrivacyUrl(value);
                    continue;
                }
                if (name.equals("privacyVersion")) {
                    pol.setPrivacyVersion(value);
                    continue;
                }
                throw new PolicyParseException("unknown paramter of policy");
            }
        } else if (top.equalsIgnoreCase("INFORMATIONCARD")) {
            String toktype = om.getAttributeValue(new QName("tokentype"));
            pol.setTokenType(toktype);
            CardSpacePolicyHelper.handleRecursiveAdd(om, requiredClaims, optionalClaims);
        } else {
            throw new PolicyParseException("no policy information found !");
        }
        pol.setRequiredClaims(requiredClaims);
        pol.setOptionalClaims(optionalClaims);
        return pol;
    }

    private static void handleRecursiveAdd(OMElement om, List requiredClaims, List optionalClaims) {
        QName opt = new QName("optional");
        QName ct = new QName("claimtype");
        Iterator iter = om.getChildrenWithName(new QName("ADD"));
        while (iter.hasNext()) {
            OMElement add = (OMElement)iter.next();
            String optional = add.getAttributeValue(opt);
            String claimtype = add.getAttributeValue(ct);
            if (optional.compareToIgnoreCase("false") == 0) {
                requiredClaims.add(claimtype);
            } else {
                optionalClaims.add(claimtype);
            }
            CardSpacePolicyHelper.handleRecursiveAdd(add, requiredClaims, optionalClaims);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

