/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *    abhi shelat
 ******************************************************************************/


package org.eclipse.higgins.iss.cardspace;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PPIDHelper;
import org.eclipse.higgins.sts.client.TokenRequestFactory;

public class PPIDCardSpacePolicy  extends CardSpacePolicy  implements ICardSpacePolicy{

	public X509Certificate x509Cert;

	byte[] ppid;

	static String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
	
	public PPIDCardSpacePolicy(X509Certificate x509cert, byte[] ppid) {
		this.x509Cert = x509cert;
		this.ppid = ppid;
		this.tokenType = "urn:oasis:names:tc:SAML:1.0:assertion";
		this.issuer = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
		requiredClaims.add(PPID_CLAIM);
	}

	public boolean isSatisfiedBy(IInformationCard icard) {
		log.trace("CardSpacePolicy::isSatisfiedBy(IInformationCard icard)");
		log.trace("icard: " + icard);

		// check issuer
		if (!issuer.equals(icard.getIssuer())) {
			log.trace("issuer not ok.");
			return false;
		}
		log.trace("issuer ok.");

		// check token type
		List suppTokenTypes = icard.getSupportedTokenTypes();
		log.trace("Supported token types: " + suppTokenTypes);

		if (suppTokenTypes == null || !suppTokenTypes.contains(tokenType)) {
			log.trace("Token type: " + tokenType + " is not supported.");
		}

		// check ppid whether the ppid from the policy matches the ppid( x509cert, card)
		TokenRequestFactory trf = new TokenRequestFactory();
		try {
			byte [] ppid_card =  PPIDHelper.computeClaimValuePPID( icard, x509Cert );
			if( Arrays.equals( ppid, ppid_card)){
				return true;
			}else{
				return false;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
	
	}
	
	

}
