/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *    abhi shelat    - initial design
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.cardspace.CardSpacePolicy;

public class CardSpacePolicyHelper {

	protected static final Log log = LogFactory.getLog(CardSpacePolicyHelper.class);

	public static CardSpacePolicy fromAxiom(OMElement om)
			throws PolicyParseException {

		CardSpacePolicy pol = new CardSpacePolicy();
		List requiredClaims = new ArrayList();
		List optionalClaims = new ArrayList();
		// abs: parsing needs to be dramatically improved, robustness, error checking, etc.

		String top = om.getLocalName();
		// check for HTML Version
		if (top.equalsIgnoreCase("OBJECT")) {
			Iterator iter = om.getChildrenWithName(new QName("PARAM"));
			while (iter.hasNext()) {
		
				OMElement om_elm = (OMElement) iter.next();
				log.trace(om_elm);
		
				String name = om_elm.getAttributeValue(new QName("name"));
				String value = om_elm.getAttributeValue(new QName("value"));
				if (name == null || value == null) {
					throw new PolicyParseException(
							"policy xml has not correct format");
				}
		
				if (name.equals("tokenType")) {
					pol.setTokenType(value);
		
				} else if (name.equals("requiredClaims")) {
					//ArrayList claims = pol.getRequiredClaims();
					
					String[] claims_split = value.split("\\s+");
					for (int i = 0; i < claims_split.length; i++) {
						if (claims_split[i].length()>0) {
							log.trace("Adding claim <" + claims_split[i]+">");
							requiredClaims.add(claims_split[i]);
						}
					}
		
				} else if (name.equals("optionalClaims")) {
					//ArrayList claims = pol.getOptionalClaims();
					String[] claims_split = value.split("\\s+");
					for (int i = 0; i < claims_split.length; i++) {
						if (claims_split[i].length()>0) {
							log.trace("Adding optional claim <" + claims_split[i]+">");
							optionalClaims.add(claims_split[i]);
						}
					}
		
				} else if( name.equals( "issuer")){
					pol.setIssuer( value );
				} else if (name.equals("issuerPolicy")){
					pol.setIssuerPolicy( value );
				} else if( name.equals( "privacyUrl")){
				    pol.setPrivacyUrl( value );
				} else if( name.equals( "privacyVersion")){
					pol.setPrivacyVersion( value );
				}else{
					throw new PolicyParseException("unknown paramter of policy");
				}		
			}
		} else if (top.equalsIgnoreCase("INFORMATIONCARD")) {
			// XHTML version
			String toktype = om.getAttributeValue(new QName("tokentype"));
			pol.setTokenType(toktype);
			// need to use recursive version b/c Firefox incorrectly parses the
			// ending /> tags of the IC:ADD elements and arranges them into a nested tree
			handleRecursiveAdd(om, requiredClaims, optionalClaims);
		} else {
			throw new PolicyParseException("no policy information found !");
		}
		pol.setRequiredClaims(requiredClaims);
		pol.setOptionalClaims(optionalClaims);
		return pol;
	}
	
	private static void handleRecursiveAdd(OMElement om, List requiredClaims, List optionalClaims) {
		QName opt = new QName("optional");
		QName ct = new QName("claimtype");
		Iterator iter = om.getChildrenWithName(new QName("ADD"));
		while (iter.hasNext()) {			
			OMElement add = (OMElement) iter.next();
			String optional = add.getAttributeValue(opt);
			String claimtype = add.getAttributeValue(ct);
			if (optional.compareToIgnoreCase("false")==0) {
				requiredClaims.add(claimtype);
			} else {
				optionalClaims.add(claimtype);
			}
			handleRecursiveAdd(add, requiredClaims, optionalClaims);
		}		
	}


}
