/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.UnsatisfiablePolicyException;
import org.eclipse.higgins.iss.cardspace.CardSpaceSelector;
import org.eclipse.higgins.iss.cardspace.ServiceConfiguration;
import org.eclipse.higgins.iss.cardspace.util.AxiomUtility;
import org.eclipse.higgins.iss.cardspace.util.CardSpacePolicyHelper;
import org.eclipse.higgins.registry.IConfiguration;

public class CardSpaceSelectorFactory
implements IICardSelectorFactory {
    protected static final Log log;
    private static final String ID = "org.eclipse.higgins.iss.cardspace";
    protected ServiceConfiguration config = new ServiceConfiguration("org.eclipse.higgins.iss.cardspace");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.iss.cardspace.CardSpaceSelectorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public IPolicy parsePolicy(String policy) throws PolicyParseException {
        log.info((Object)("policy=\"" + policy + "\""));
        OMElement om = AxiomUtility.getAxiomFromString(policy);
        CardSpacePolicy pol = CardSpacePolicyHelper.fromAxiom(om);
        log.trace((Object)("policy=\"" + pol + "\""));
        return pol;
    }

    public IICardSelector getICardSelector(CallbackHandler handler, IPolicy policy) throws UnsatisfiablePolicyException {
        if (policy instanceof ICardSpacePolicy) {
            return new CardSpaceSelector(this.getSTSConfigurationBase(), handler, (ICardSpacePolicy)policy);
        }
        throw new UnsatisfiablePolicyException("Invalid cardspace policy: " + policy);
    }

    public IICardSelector getICardSelector(CallbackHandler handler, String policy) throws PolicyParseException, UnsatisfiablePolicyException {
        IPolicy p = this.parsePolicy(policy);
        return this.getICardSelector(handler, p);
    }

    public String getID() {
        return ID;
    }

    public void setID(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IConfiguration getConfiguration() {
        return this.config;
    }

    public String getSTSConfigurationBase() {
        return this.config.getSTSConfigurationBase();
    }
}

