/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.security.auth.callback.CallbackHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.UserChoiceTree_OR;
import org.eclipse.higgins.iss.cardspace.util.STSHelper;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;

public class CardSpaceSelector2 implements IICardSelector {
	protected static final Log log = LogFactory.getLog(CardSpaceSelector2.class);
	
	
	protected ICardSpacePolicy policy;
	protected CallbackHandler handler;
	protected String stsConfigurationBase;

	protected ICardRegistry registry = ICardRegistry.getInstance();
	
	public CardSpaceSelector2(String stsConfigurationBase, CallbackHandler handler, ICardSpacePolicy policy) {
		this.handler = handler;
		this.policy = policy;
		this.stsConfigurationBase = stsConfigurationBase;
	}
	
	public IPolicy getPolicy() {
		return policy;
	}

	public CallbackHandler getCallbackHandler() {
		return handler;
	}

	public UserChoiceTree getUserChoice() throws Exception {
		log.info("CardSpaceICardSelector::getUserChoice()");
		log.info("policy: " + policy);
		UserChoiceTree res;
		List list = new ArrayList();
		List l = new ArrayList();
		Class[] iCardTypes = policy.getICardTypes();
		for (Iterator itr = registry.getICardProviders(); itr.hasNext(); ) {
			ICardProvider p = (ICardProvider) itr.next();
			boolean hasRequiredTypes = false;
			for (int i = 0; i < iCardTypes.length; i++) {
				Class[] supportedTypes = p.getSupportedTypes();
				for (int j = 0; j < supportedTypes.length; j++) {
					if (iCardTypes[i].isAssignableFrom(supportedTypes[j])) {
						hasRequiredTypes = true;
						break;
					}
				}
				if (hasRequiredTypes) {
					break;
				}
			}
			if (hasRequiredTypes) {
//				List l = new ArrayList();
				try {
					for(Iterator cards = p.getICardsByPolicy(handler, policy); cards.hasNext(); ) {
						ICard card = (ICard) cards.next();
						CredentialContainer cc = new CredentialContainer(card, card.getCUID().toString());
						l.add(cc);
					}
				} catch (Exception e) {
					log.error("CardSpaceICardSelector::getUserChoice()", e);
					//e.printStackTrace();
				}
				/*
				if (l.size() > 0) {
					UCTelm elm = new UCTelm(policy, l);
					list.add(new UserChoiceTree_OR(elm));
				}
				*/
			}
		}
		if (l.size() > 0) {
			UCTelm elm = new UCTelm(policy, l);
			list.add(new UserChoiceTree_OR(elm));
		}
		res = new UserChoiceTree_ANDofORs(list); 
		return res;
	}

	public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws Exception {
		// extract Infocard out of the selection (we assume that is the first
		// leave from the leave)
//		String credential_db_uri = selection.cardspace_credential_db_uri;
		SelectionANDofORsElm elm = (SelectionANDofORsElm) selection.getElements().get(0);
		String uid = elm.getUUID();
		
		final ConfigurationHandler ch = getConfigurationHandler(false);
		Map mapGlobalSettings = ch.getSettings();
		final IBase64Extension base64Extension = (org.eclipse.higgins.sts.spi.IBase64Extension)mapGlobalSettings.get("Base64Extension");
		
		// TODO !!!!!!! Use ICardRegistry instead below
		//CardSpaceCardRegistry reg = new CardSpaceCardRegistry(credential_db_uri);
		IInformationCard infocard = (IInformationCard) registry.getICardByCUID(handler, uid);

		// create token
		STSHelper stsHelper = new STSHelper(stsConfigurationBase, infocard, policy, selection.username, selection.password );
		stsHelper.setX509Certificate((selection.sslCertChain)[0]);
		//stsHelper.uriTokenService = new java.net.URI("http://localhost:8080/TokenService/services/Trust");
		//stsHelper.uriMetadataService = new java.net.URI("https://infocard.pingidentity.com/idpdemo/mex");
		ISTSResponse response = stsHelper.getToken();
		//return response;
		
		System.out.println("\t====>>>> Site SSL Sertificate: [[" + (selection.sslCertChain)[0] + "]]");
		//return new IdentityToken(response, selection.sslCert==null?null:Base64.encode(selection.sslCert.getEncoded()));
		return new IdentityToken(response, selection.sslCertChain == null ? null : base64Extension.encode((selection.sslCertChain)[0].getEncoded()));
		
		/*
		List listRSTR = response.getRequestSecurityTokenResponseCollection();
		String strEncryptedToken = null;
		if (1 == listRSTR.size())
		{
			IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTR.get(0);
			IElement elemToken = RSTR.getRequestedSecurityToken();
			String strToken = (String)elemToken.getAs(String.class);
			System.err.println("Token: " + strToken);
			
			IConstants constants = new Constants();
			
			/// This must be done before the Token is handed off to a Browser to be POSTed to the RP.
			OMElement omEncryptedToken = null;
			OMElement omRequestedSecurityToken = (OMElement)elemToken.getAs(OMElement.class);
			QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData"); 	
			QName qnameSAMLAssertion = new QName(constants.getSAML10Namespace().toString(), "Assertion"); 
			OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
			if (null != omReturnedSAMLAssertion)
			{
				IXMLSecurityExtension xmlSecurity = null;//(IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
				if (null == xmlSecurity)
				{
					IConfigurableComponentFactory xmlSecurityFactory = new XMLSecurityApacheExtensionFactory();
					xmlSecurity = (IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
					xmlSecurity.configure(null, null, null);
				}
			    OMElement omEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion",
					omRequestedSecurityToken,
					selection.sslCert.toString());
			    omEncryptedToken = omEncryptedRequestedSecurityToken.getFirstElement();
			}
			else
			{
				OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
				if (null != omReturnedEncryptedData)
				{
					omEncryptedToken = omReturnedEncryptedData;
				}
				else
				{
					System.err.println("Unexpected RequestedSecurityToken");
				}
			}
			strEncryptedToken = XMLHelper.toString(omEncryptedToken);
			System.err.println("Encrypted Token: " + strEncryptedToken);
			// At this point the omEncryptedToken should be POSTed to the RP.
		}

		return strEncryptedToken;
		*/
	}
	
	public ConfigurationHandler getConfigurationHandler(boolean selfIssued) throws Exception {
		if (null == stsConfigurationBase) {
			stsConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
		}
		if (null == stsConfigurationBase) {
			throw new Exception("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
		}


		String stsConfigurationFile = System.getProperty("org.eclipse.higgins.sts.conf.file");
		if (stsConfigurationFile == null) {
			stsConfigurationFile = "ClientConfiguration.xml";
		}

		final org.eclipse.higgins.configuration.xml.ConfigurationHandler configurationHandler = new org.eclipse.higgins.configuration.xml.ConfigurationHandler();
		configurationHandler.setConfigurationBase(stsConfigurationBase);
		
		configurationHandler.setFileName(stsConfigurationFile);

		if (!configurationHandler.configure(null)) {
			log.error("Not Initialized!");
			throw new Exception("CardspaceSelector: cannot initialize configHandler");
		}

		return configurationHandler;
	}
	
	
	
}
