/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    abhi shelat (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.iss.cardspace;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CardspaceDisplayMappings {
	private static final String BUNDLE_NAME = "org.eclipse.higgins.iss.cardspace.cardspacedisplaymapping"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private CardspaceDisplayMappings() {
	}

	public static String getString(String key) {
		String k=key;
		try {
			k = key.replace(':', '-');
			return RESOURCE_BUNDLE.getString(k);
		} catch (MissingResourceException e) {
			System.out.println("**** MISSING map for " + k);
			return key;
		}
	}
}
