/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.utils.ConfigUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceConfiguration implements IConfiguration {
	private Log log = LogFactory.getLog(ServiceConfiguration.class);
	
	public static final String STS_CONFIGURATION_BASE = "sts.configuration.base";
	
	private String id = null;
	
	private Properties defaults = null;
	
	private Properties properties = null;

	/**
	 * 
	 */
	public ServiceConfiguration(String id) {
		this.id = id;
		loadDefaults();
		properties = new Properties(defaults);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#load(java.io.File)
	 */
	public void load(File config) {
		log.trace("config=\"" + config + "\"");
		FileInputStream in = null;
		try {
			in = new FileInputStream(config);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			Document doc = null;
			DocumentBuilder db = dbf.newDocumentBuilder();
			doc = db.parse(new InputSource(in));
			Element root = doc.getDocumentElement();
			String id = root.getAttribute("id");
			if (id != null) {
				if (!id.equals(this.id)) {
					log.trace("Warning: provider id doesn't match - " + this.id + "!=" + id);
				}
			}
			setProperties(loadProperties(root));
		} catch (Exception e) {
			log.warn("Can't load configuration", e);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (Exception e) {
					log.trace(e);
				}
			}
		}
		log.trace("properties=\"" + properties + "\"");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#save(java.io.File)
	 */
	public void save(File config) {
		// TODO Auto-generated method stub
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getPropertyNames()
	 */
	public Iterator getPropertyNames() {
		List list = new ArrayList();
		for (Enumeration e = defaults.propertyNames(); e.hasMoreElements(); ) {
			String s = (String) e.nextElement();
			list.add(s);
		}
		return list.iterator();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String)
	 */
	public String getProperty(String key) {
		return properties.getProperty(key);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String, java.lang.String)
	 */
	public String getProperty(String key, String defaultValue) {
		return properties.getProperty(key, defaultValue);
	}

	private void loadDefaults() {
		defaults = new Properties();
		InputStream is = null;
		try {
			is = Thread.currentThread().getContextClassLoader()
					.getResourceAsStream(id + ".ini");
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			Document doc = null;
			DocumentBuilder db = dbf.newDocumentBuilder();
			doc = db.parse(new InputSource(is));
			Element root = doc.getDocumentElement();
			String id = root.getAttribute("id");
			if (id != null) {
				if (!id.equals(this.id)) {
					log.trace("Warning: provider id doesn't match - " + this.id + "!=" + id);
				}
			}
			defaults = loadProperties(root); 
		} catch (Exception e) {
			log.error("Can't load default configuration", e);
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					log.trace(e);
				}
			}
		}
		log.trace("defaults=\"" + defaults + "\"");
	}
	
	private Properties loadProperties(Element e) {
		Properties props = new Properties();
		NodeList nl = e.getChildNodes();
		for (int i = 0; i < nl.getLength(); i++) {
			Node node = nl.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE
					&& node.getNodeName().equals("parameter")) {
				Element el = (Element) node;
				String name = el.getAttribute("name");
				if (name.length() > 0) {
					String value = el.getAttribute("value");
					props.put(name, value);
				}
			}
		}
		return props;
	}
	
	private void setProperties(Properties properties) {
		this.properties = new Properties(defaults);
		for (Iterator itr = properties.keySet().iterator(); itr.hasNext(); ) {
			String k = (String) itr.next();
			this.properties.setProperty(k, properties.getProperty(k));
		}
	}
	
	public String getSTSConfigurationBase() {
		//TODO check/resolve returned property to ensure that configuration dir exists
		String resolvedDir = null;
		// Check existence of org.eclipse.higgins.sts.conf and use it to override 
		// default configuration base
		String dir = System.getProperty("org.eclipse.higgins.sts.conf");
		if (dir == null) {
			dir = getProperty(STS_CONFIGURATION_BASE);
		}
		if (dir != null) {
			resolvedDir = ConfigUtil.resolvePath(dir);
			log.trace("STSConfigurationBase=\"" + dir + "\" has been relolved to=\"" + resolvedDir + "\"");
		}
		return resolvedDir;
	}
}
