package org.eclipse.higgins.iss.cardspace.util;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.sts.api.ISTSResponse;

public class UserProfileTokenHelper {
	
	public static ISTSResponse getToken(X509Certificate certificate, Hashtable claims) throws Exception {
		CardSpacePolicy policy = new CardSpacePolicy();
		ArrayList requiredClaims = new ArrayList();
		Enumeration keys = claims.keys();
		while (keys.hasMoreElements())
			requiredClaims.add(keys.nextElement());
		policy.setRequiredClaims(requiredClaims);
		IInformationCard card = new VirtualPersonalCard(claims);
		STSHelper hs = new STSHelper(null, card, policy, null, null);
		hs.setX509Certificate(certificate);
		return hs.getToken_SelfSignedCard();
	}

}
