/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.UserChoiceTree_OR;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.iss.cardspace.util.STSHelper;
import org.eclipse.higgins.sts.api.ISTSResponse;

public class CardSpaceSelector2
implements IICardSelector {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2 == null ? (class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2 = CardSpaceSelector2.class$("org.eclipse.higgins.iss.cardspace.CardSpaceSelector2")) : class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2));
    protected ICardSpacePolicy policy;
    protected CallbackHandler handler;
    protected String stsConfigurationBase;
    protected ICardRegistry registry = ICardRegistry.getInstance();
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$CardSpaceSelector2;

    public CardSpaceSelector2(String stsConfigurationBase, CallbackHandler handler, ICardSpacePolicy policy) {
        this.handler = handler;
        this.policy = policy;
        this.stsConfigurationBase = stsConfigurationBase;
    }

    public IPolicy getPolicy() {
        return this.policy;
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public UserChoiceTree getUserChoice() throws Exception {
        log.info((Object)"CardSpaceICardSelector::getUserChoice()");
        log.info((Object)("policy: " + this.policy));
        ArrayList<UserChoiceTree_OR> list = new ArrayList<UserChoiceTree_OR>();
        ArrayList<CredentialContainer> l = new ArrayList<CredentialContainer>();
        Class[] iCardTypes = this.policy.getICardTypes();
        Iterator itr = this.registry.getICardProviders();
        while (itr.hasNext()) {
            ICardProvider p = (ICardProvider)itr.next();
            boolean hasRequiredTypes = false;
            for (int i = 0; i < iCardTypes.length; ++i) {
                Class[] supportedTypes = p.getSupportedTypes();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    if (!iCardTypes[i].isAssignableFrom(supportedTypes[j])) continue;
                    hasRequiredTypes = true;
                    break;
                }
                if (hasRequiredTypes) break;
            }
            if (!hasRequiredTypes) continue;
            try {
                Iterator cards = p.getICardsByPolicy(this.handler, (IPolicy)this.policy);
                while (cards.hasNext()) {
                    ICard card = (ICard)cards.next();
                    CredentialContainer cc = new CredentialContainer(card, card.getCUID().toString());
                    l.add(cc);
                }
            }
            catch (Exception e) {
                log.error((Object)"CardSpaceICardSelector::getUserChoice()", (Throwable)e);
            }
        }
        if (l.size() > 0) {
            UCTelm elm = new UCTelm((IPolicy)this.policy, l);
            list.add(new UserChoiceTree_OR(elm));
        }
        UserChoiceTree_ANDofORs res = new UserChoiceTree_ANDofORs(list);
        return res;
    }

    public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws Exception {
        SelectionANDofORsElm elm = (SelectionANDofORsElm)selection.getElements().get(0);
        String uid = elm.getUUID();
        ConfigurationHandler ch = this.getConfigurationHandler(false);
        Map mapGlobalSettings = ch.getSettings();
        IInformationCard infocard = (IInformationCard)this.registry.getICardByCUID(this.handler, uid);
        STSHelper stsHelper = new STSHelper(this.stsConfigurationBase, infocard, this.policy, selection.username, selection.password);
        stsHelper.setX509Certificate(selection.sslCertChain[0]);
        ISTSResponse response = stsHelper.getToken();
        System.out.println("\t====>>>> Site SSL Sertificate: [[" + selection.sslCertChain[0] + "]]");
        return new IdentityToken(response, selection.sslCertChain == null ? null : new String(Base64.encodeBase64((byte[])selection.sslCertChain[0].getEncoded())));
    }

    public ConfigurationHandler getConfigurationHandler(boolean selfIssued) throws Exception {
        if (null == this.stsConfigurationBase) {
            this.stsConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        }
        if (null == this.stsConfigurationBase) {
            throw new Exception("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
        }
        String stsConfigurationFile = System.getProperty("org.eclipse.higgins.sts.conf.file");
        if (stsConfigurationFile == null) {
            stsConfigurationFile = "ClientConfiguration.xml";
        }
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        configurationHandler.setConfigurationBase(this.stsConfigurationBase);
        configurationHandler.setFileName(stsConfigurationFile);
        if (!configurationHandler.configure(null)) {
            log.error((Object)"Not Initialized!");
            throw new Exception("CardspaceSelector: cannot initialize configHandler");
        }
        return configurationHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

