/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.UnsupportedElementFormatException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;

public class VirtualPersonalCard
implements IPersonalInformationCard {
    public static final String issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
    public static final String issuerName_ = "Self";
    private String cardID_ = "urn:" + System.currentTimeMillis();
    private ArrayList claims_ = new ArrayList();
    private ArrayList supportedClaimTypes_ = new ArrayList();
    private ArrayList supportedClaimTypeURI_ = new ArrayList();
    private ArrayList supportedTokenTypes_;
    private Hashtable claimToType_ = new Hashtable();

    public VirtualPersonalCard(Hashtable claims) throws Exception {
        Enumeration keys = claims.keys();
        while (keys.hasMoreElements()) {
            String type;
            boolean isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type = (String)keys.nextElement());
            this.supportedClaimTypes_.add(new ClaimType(type, "", "", !isPPID, !isPPID));
            this.supportedClaimTypeURI_.add(new URI(type));
            String value = (String)claims.get(type);
            ClaimType claimType = new ClaimType(type, "", "", !isPPID, !isPPID);
            ClaimValue claimValue = new ClaimValue((ISimpleClaimType)claimType, value);
            this.claims_.add(claimValue);
            this.claimToType_.put(type, claimValue);
        }
        this.supportedTokenTypes_ = new ArrayList();
        this.supportedTokenTypes_.add(URI.create("urn:oasis:names:tc:SAML:1.0:assertion"));
        this.supportedTokenTypes_.add(URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
    }

    public URI getClaimListContextID() {
        return null;
    }

    public String getClaimListEntityID() {
        return null;
    }

    public byte[] getPinDigest() throws CardException {
        return null;
    }

    public void setClaimList(List claims) throws CardException {
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
    }

    public byte[] getHashSalt() {
        return CardCryptography.getRandomBytes((int)16);
    }

    public byte[] getMasterKey() throws CardException {
        return CardCryptography.getRandomBytes((int)32);
    }

    public IElement toElement(IElementFormat format) throws CardException, CardIOException, UnsupportedElementFormatException {
        return null;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
    }

    public void beginUpdates() throws InvalidStateException {
    }

    public void cancelUpdates() throws InvalidStateException {
    }

    public CUID getCUID() {
        return new CUID("virtual", issuer_, this.cardID_);
    }

    public IClaim getClaimByLocalName(String typeLocalName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getID() {
        return this.cardID_;
    }

    public byte[] getImage() {
        return null;
    }

    public String getImageType() {
        return null;
    }

    public String getIssuer() {
        return issuer_;
    }

    public String getIssuerName() {
        return issuerName_;
    }

    public String getName() {
        return issuerName_;
    }

    public ICardProvider getProvider() {
        return null;
    }

    public List getSupportedClaimTypesUris() {
        return this.supportedClaimTypeURI_;
    }

    public List getSupportedTokenTypes() {
        return this.supportedClaimTypes_;
    }

    public Date getTimeExpires() {
        return null;
    }

    public Date getTimeIssued() {
        return new Date(0L);
    }

    public Date getTimeLastUpdated() {
        return new Date(0L);
    }

    public String getType() {
        return "cardspace_type";
    }

    public String getVersion() {
        return "1";
    }

    public boolean isEditMode() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isSelfIssued() {
        return true;
    }

    public void setImage(byte[] newImage, String newImageType) throws CardException {
    }

    public void setIssuerName(String name) throws CardException {
    }

    public void setName(String newName) throws CardException {
    }

    public void setTimeExpires(Date date) throws CardException {
    }

    public Iterator getSupportedClaimTypes() {
        return this.supportedClaimTypes_.iterator();
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        return null;
    }

    public IClaim getClaim(String type) throws InvalidTypeException {
        if (type == null) {
            return null;
        }
        if (this.claimToType_.containsKey(type)) {
            return (ClaimValue)this.claimToType_.get(type);
        }
        return null;
    }

    public Iterator getClaims() throws CardException {
        return this.claims_.iterator();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        return null;
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        return null;
    }

    public boolean isClaimsRetrieved() {
        return true;
    }

    public boolean isFormatSupported(IElementFormat format) {
        return false;
    }

    public byte[] getIssuerID() {
        return null;
    }
}

