package org.eclipse.higgins.iss.cardspace.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardConstants;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.UnsupportedElementFormatException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;

public class VirtualPersonalCard  implements IPersonalInformationCard {

	public static final String issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
	public static final String issuerName_ = "Self";

	private String cardID_;
	
	private ArrayList claims_;
	
	private ArrayList supportedClaimTypes_;

	private ArrayList supportedClaimTypeURI_;

	private ArrayList supportedTokenTypes_;
	private Hashtable claimToType_;


	public VirtualPersonalCard (Hashtable claims) throws Exception {
		cardID_ = "urn:" + System.currentTimeMillis();
		claims_ = new ArrayList();
		supportedClaimTypes_ = new ArrayList();
		supportedClaimTypeURI_ = new ArrayList();
		claimToType_ = new Hashtable();
		Enumeration keys = claims.keys();
		while (keys.hasMoreElements()) {
			String type = (String)keys.nextElement();
			boolean isPPID = SelfIssuedCardClaims.PPID_TYPE.equals(type); 
			supportedClaimTypes_.add(new ClaimType(type, "", "", !isPPID, !isPPID));
			supportedClaimTypeURI_.add(new URI(type));
			String value = (String)claims.get(type);
			ClaimType claimType = new ClaimType(type, "", "", !isPPID, !isPPID);
			ClaimValue claimValue = new ClaimValue(claimType, value);
			claims_.add(claimValue);
			claimToType_.put(type, claimValue);
		}
		supportedTokenTypes_ = new ArrayList();
		supportedTokenTypes_.add(URI.create("urn:oasis:names:tc:SAML:1.0:assertion"));
		supportedTokenTypes_.add(URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
	}

	public URI getClaimListContextID() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getClaimListEntityID() {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getPinDigest() throws CardException {
		return null;
	}

	public void setClaimList(List claims) throws CardException {
	}

	public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
	}

	public byte[] getHashSalt() {
		return CardCryptography.getRandomBytes(16);
	}

	public byte[] getMasterKey() throws CardException {
		return CardCryptography.getRandomBytes(32);
	}

	public IElement toElement(IElementFormat format) throws CardException, CardIOException, UnsupportedElementFormatException {
		return null;
	}

	public void applyUpdates() throws InvalidStateException, CardException {
	}

	public void beginUpdates() throws InvalidStateException {
	}

	public void cancelUpdates() throws InvalidStateException {
	}

	public CUID getCUID() {
		return new CUID("virtual", issuer_, cardID_); 
	}

	public IClaim getClaimByLocalName(String typeLocalName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
		return null;
	}

	public String getDescription() {
		return null;
	}

	public String getID() {
		return cardID_;
	}
	
	public byte[] getImage() {
		return null;
	}

	public String getImageType() {
		return null;
	}

	public String getIssuer() {
		return issuer_;
	}

	public String getIssuerName() {
		return issuerName_;
	}

	public String getName() {
		return "Self";
	}

	public ICardProvider getProvider() {
		return null;
	}

	public List getSupportedClaimTypesUris() {
		return supportedClaimTypeURI_;
	}

	public List getSupportedTokenTypes() {
		return supportedClaimTypes_;
	}

	public Date getTimeExpires() {
		return null;
	}

	public Date getTimeIssued() {
		return new Date(0);
	}

	public Date getTimeLastUpdated() {
		return new Date(0);
	}

	public String getType() {
		return ICardConstants.I_CARD_TYPE_CARDSPACE;
	}

	public String getVersion() {
		return "1";
	}

	public boolean isEditMode() {
		return false;
	}

	public boolean isEditable() {
		return false;
	}

	public boolean isSelfIssued() {
		return true;
	}

	public void setImage(byte[] newImage, String newImageType) throws CardException {
	}

	public void setIssuerName(String name) throws CardException {
	}

	public void setName(String newName) throws CardException {
	}

	public void setTimeExpires(Date date) throws CardException {
	}

	public Iterator getSupportedClaimTypes() {
		return supportedClaimTypes_.iterator();
	}

	public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
		return null;
	}

	public IClaim getClaim(String type) throws InvalidTypeException {
		if (type == null)
			return null;
		if (claimToType_.containsKey(type))
			return (ClaimValue)claimToType_.get(type);
		return null;
	}

	public Iterator getClaims() throws CardException {
		return claims_.iterator();
	}

	public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
		return null;
	}

	public ICredentialDescriptor[] getRequiredCredentials() {
		return null;
	}

	public boolean isClaimsRetrieved() {
		return true;
	}

	public boolean isFormatSupported(IElementFormat format) {
		// TODO Auto-generated method stub
		return false;
	}

	public byte[] getIssuerID() {
		// TODO Auto-generated method stub
		return null;
	}
}
