/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.net.URI;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.IX509V3Credential;
import org.eclipse.higgins.icard.common.auth.callback.X509V3Callback;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.PPIDCardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSFaultException;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.UserChoiceTree_OR;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.registry.KeyStoreRegistry;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityToken;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.PPIDHelper;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.BinarySecurityToken;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.SAML11Token;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class CardSpaceSelector
implements IICardSelector {
    protected static final Log log;
    static String PPID_CLAIM;
    static String URI_BASE64;
    static String URI_WSS_X509;
    static String URI_THUMBPRINT;
    protected ICardSpacePolicy policy;
    protected CallbackHandler handler;
    protected String stsConfigurationBase;
    protected ICardRegistry registry = ICardRegistry.getInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.iss.cardspace.CardSpaceSelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
        URI_BASE64 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
        URI_WSS_X509 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
        URI_THUMBPRINT = "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.1#ThumbprintSHA1";
    }

    public CardSpaceSelector(String stsConfigurationBase, CallbackHandler handler, ICardSpacePolicy policy) {
        this.handler = handler;
        this.policy = policy;
        this.stsConfigurationBase = stsConfigurationBase;
    }

    public IPolicy getPolicy() {
        return this.policy;
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public UserChoiceTree getUserChoice() throws Exception {
        log.trace((Object)"CardSpaceICardSelector::getUserChoice()");
        log.trace((Object)("policy: " + this.policy));
        ArrayList<UserChoiceTree_OR> orTreeList = new ArrayList<UserChoiceTree_OR>();
        Class[] iCardTypes = this.policy.getICardTypes();
        ArrayList<CredentialContainer> cardList = new ArrayList<CredentialContainer>();
        Iterator itr = this.registry.getICardProviders();
        while (itr.hasNext()) {
            ICardProvider p = (ICardProvider)itr.next();
            boolean hasRequiredTypes = false;
            int i = 0;
            while (i < iCardTypes.length) {
                Class[] supportedTypes = p.getSupportedTypes();
                int j = 0;
                while (j < supportedTypes.length) {
                    if (iCardTypes[i].isAssignableFrom(supportedTypes[j])) {
                        hasRequiredTypes = true;
                        break;
                    }
                    ++j;
                }
                if (hasRequiredTypes) break;
                ++i;
            }
            if (!hasRequiredTypes) continue;
            try {
                Iterator cards = p.getICardsByPolicy(this.handler, (IPolicy)this.policy);
                while (cards.hasNext()) {
                    ICard card = (ICard)cards.next();
                    CredentialContainer cc = new CredentialContainer(card, card.getCUID().toString());
                    cardList.add(cc);
                }
            }
            catch (Exception e) {
                log.error((Object)"CardSpaceICardSelector::getUserChoice()", (Throwable)e);
            }
        }
        UCTelm elm = new UCTelm((IPolicy)this.policy, cardList);
        orTreeList.add(new UserChoiceTree_OR(elm));
        UserChoiceTree_ANDofORs res = new UserChoiceTree_ANDofORs(orTreeList);
        return res;
    }

    public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws STSFaultException, Exception {
        SelectionANDofORsElm elm = (SelectionANDofORsElm)selection.getElements().get(0);
        String uid = elm.getUUID();
        IInformationCard infocard = (IInformationCard)this.registry.getICardByCUID(this.handler, uid);
        URI uriRP = null;
        try {
            uriRP = URI.create(XMLHelper.escapedString((String)selection.action));
        }
        catch (Exception exception) {}
        boolean selfIssued = infocard.isSelfIssued();
        ConfigurationHandler ch = this.getConfigurationHandler(selfIssued);
        Map mapGlobalSettings = ch.getSettings();
        Constants constants = new Constants();
        TokenRequestFactory factoryRequest = new TokenRequestFactory();
        STSResponse stsResponse = new STSResponse();
        ISTSRequest stsRequest = null;
        KeyStore ksTrusted = (KeyStore)mapGlobalSettings.get("TrustedKeyStore");
        ArrayList<Certificate> collCertificates = new ArrayList<Certificate>();
        Enumeration<String> enumCertificates = ksTrusted.aliases();
        while (enumCertificates.hasMoreElements()) {
            String strAlias = enumCertificates.nextElement();
            Certificate cert = ksTrusted.getCertificate(strAlias);
            collCertificates.add(cert);
        }
        new CollectionCertStoreParameters(collCertificates);
        CertStore certStoreTrust = KeyStoreRegistry.getInstance().getSecurityService().getCertStore(this.handler);
        if (selection.sslCertChain != null && selection.sslCertChain.length > 0) {
            log.trace((Object)("@@@@@@@@@ X509 CERT is " + selection.sslCertChain[0]));
        }
        if (infocard instanceof IManagedInformationCard) {
            IElement elemClaims = this.makeClaims(this.policy, infocard, selection, certStoreTrust);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log.trace(elemClaims.getAs((Class)clazz));
            IManagedInformationCard managed = (IManagedInformationCard)infocard;
            ISecurityTokenService stsManaged = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
            ISecurityTokenService stsBinding = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceBinding");
            ICredential credential = selection.getCredential();
            URI uriTokenService = null;
            X509Certificate endpointCert = null;
            if (credential instanceof ITokenServiceCredential) {
                ITokenServiceCredential tsc = (ITokenServiceCredential)credential;
                uriTokenService = tsc.getAddress();
                endpointCert = tsc.getCertificate();
                tsc.getMetadataAddress();
            }
            if (credential instanceof ISelfIssuedCredential) {
                PPIDCardSpacePolicy ppp;
                CardSpaceSelector subselector;
                UserChoiceTree_ANDofORs uct;
                SelectionANDofORs subselection;
                ISelfIssuedCredential sic = (ISelfIssuedCredential)credential;
                log.trace((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.trace((Object)"Create request for managed card with self issued saml as authentification");
                String ppid = sic.getPPID();
                byte[] bppid = Base64.decodeBase64((byte[])ppid.getBytes());
                log.info((Object)("CERT inside the card is " + endpointCert));
                IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
                X509Certificate[] chainOriginal = new X509Certificate[]{endpointCert};
                X509Certificate[] chain = null;
                if (chainOriginal != null) {
                    try {
                        chain = securityService.getValidateCertificateChain(this.handler, chainOriginal, uriTokenService);
                    }
                    catch (CertificateException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    catch (CertStoreException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
                if (chain == null) {
                    chain = chainOriginal;
                }
                if ((subselection = (uct = (UserChoiceTree_ANDofORs)(subselector = new CardSpaceSelector(this.stsConfigurationBase, this.handler, (ICardSpacePolicy)(ppp = new PPIDCardSpacePolicy(chain, certStoreTrust, bppid)))).getUserChoice()).getDefaultSelection()).isEmpty()) {
                    System.out.println("Cannot find the Personal card used to authenticate for this managed card.");
                    throw new Exception("Cannot find the Personal card used to authenticate for this managed card.");
                }
                subselection.action = infocard.getIssuer();
                subselection.sslCertChain = chain;
                subselection.setCredential((ICredential)sic.getPinCodeCredential());
                IIdentityToken subtok = subselector.getIdentityToken(subselection);
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.higgins.sts.api.IElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IElement elemSubTok = (IElement)subtok.getAs((Class)clazz2);
                SAML11Token samlSubTok = new SAML11Token();
                samlSubTok.fromElement(elemSubTok);
                StringBuffer stringBuffer = new StringBuffer("\n\n\n SSS AUTH: ");
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                log.info((Object)stringBuffer.append(subtok.getAs((Class)clazz3)).append("\n\n\n").toString());
                stsRequest = factoryRequest.createManagedRequest(uriRP, selection.sslCertChain, certStoreTrust, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, (ISecurityToken)samlSubTok);
                log.trace((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.trace((Object)"create request for managed card with self issued saml as authentification done ");
            } else if (credential instanceof IUsernamePasswordCredential) {
                IUsernamePasswordCredential unpc = (IUsernamePasswordCredential)credential;
                String username = unpc.getUsername();
                String password = unpc.getPassword();
                System.out.println("username : " + username);
                System.out.println("password : " + password);
                TokenService ts = (TokenService)managed.getTokenServices().get(0);
                uriTokenService = ts.getEndpointReference().getAddress();
                log.trace((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.trace((Object)"Create request for managed card with username/password as authentification");
                stsRequest = factoryRequest.createManagedRequest(uriRP, selection.sslCertChain, certStoreTrust, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, username, password);
                log.trace((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ");
                log.trace((Object)"create request for managed card with username/password as authentification done");
            } else if (credential instanceof IX509V3Credential) {
                Enumeration<String> aliases;
                Callback[] callbacks = credential.getCallbacks();
                X509V3Callback x5cb = null;
                int i = 0;
                while (i < callbacks.length) {
                    if (callbacks[i] instanceof X509V3Callback) {
                        x5cb = (X509V3Callback)callbacks[i];
                    }
                    ++i;
                }
                if (x5cb == null) {
                    throw new Exception("Cannot find certificate identifier from the i-card");
                }
                String value_type = x5cb.getValueType();
                String sha1_digest = x5cb.getEncoded_key();
                Certificate client_cert = null;
                String client_cert_alias = "";
                if (URI_THUMBPRINT.equals(value_type) && (aliases = ksTrusted.aliases()) != null) {
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!ksTrusted.isKeyEntry(alias)) continue;
                        X509Certificate cert = (X509Certificate)ksTrusted.getCertificate(alias);
                        byte[] cert_der = cert.getEncoded();
                        MessageDigest md = MessageDigest.getInstance("SHA");
                        md.update(cert_der);
                        byte[] digest = md.digest();
                        String cert_digest = org.apache.xml.security.utils.Base64.encode((byte[])digest);
                        if (!sha1_digest.equals(cert_digest)) continue;
                        client_cert = cert;
                        client_cert_alias = alias;
                        break;
                    }
                }
                if (client_cert == null) {
                    throw new Exception("Cannot find client certificate to access this IDP");
                }
                PrivateKey client_pk = (PrivateKey)mapGlobalSettings.get(client_cert_alias);
                if (client_pk == null) {
                    throw new Exception("configure error: cannot find your privatey key");
                }
                String cert_token = org.apache.xml.security.utils.Base64.encode((byte[])client_cert.getEncoded());
                BinarySecurityToken bst = new BinarySecurityToken();
                bst.setEncodedValue(cert_token);
                bst.setEncodingType(new URI(URI_BASE64));
                bst.setValueType(new URI(URI_WSS_X509));
                TokenService ts = (TokenService)managed.getTokenServices().get(0);
                uriTokenService = ts.getEndpointReference().getAddress();
                log.trace((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                log.trace((Object)"Create request for managed card with X509 v3 certificate as authentification");
                stsRequest = factoryRequest.createManagedRequest(uriRP, selection.sslCertChain, certStoreTrust, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), infocard, elemClaims, client_pk, (ISecurityToken)bst);
            } else {
                throw new Exception("Unsupported user credential " + credential);
            }
            mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
            stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null);
            log.trace((Object)"Invoke STS for managed card.");
            stsManaged.invoke(mapGlobalSettings, null, null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
            log.trace((Object)"%%%% END OF MANAGED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% done ");
        } else if (infocard instanceof IPersonalInformationCard) {
            PersonalCard pcard;
            if (infocard instanceof PersonalCard && (pcard = (PersonalCard)infocard).getPinStatus() == 1) {
                IPinCodeCredential ipc = null;
                ICredential cred = selection.getCredential();
                if (cred != null && cred instanceof IPinCodeCredential) {
                    ipc = (IPinCodeCredential)cred;
                    pcard.unlock(ipc);
                } else {
                    throw new Exception("The personal card is PIN code locked.");
                }
            }
            IPersonalInformationCard pesonal = (IPersonalInformationCard)infocard;
            ICardProvider provider = pesonal.getProvider();
            ICredential credential = selection.getCredential();
            pesonal = credential != null ? (IPersonalInformationCard)provider.getICardByCUID(this.handler, pesonal.getCUID(), credential) : (IPersonalInformationCard)provider.getICardByCUID(this.handler, pesonal.getCUID());
            IElement elemClaims = this.makeClaims(this.policy, (IInformationCard)pesonal, selection, certStoreTrust);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log.trace(elemClaims.getAs((Class)clazz));
            ISecurityTokenService stsPersonal = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
            log.trace((Object)"Create request for self signed card");
            stsRequest = factoryRequest.createPersonalRequest(uriRP, selection.sslCertChain, certStoreTrust, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)pesonal, elemClaims);
            log.trace((Object)"Invoke STS for self signed card.");
            stsPersonal.invoke(mapGlobalSettings, "SecurityTokenService", null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
        }
        if (stsResponse.getFault() != null) {
            log.error((Object)("Returning STS Fault: " + stsResponse.getFault().getDetail()));
            throw new STSFaultException(stsResponse.getFault());
        }
        String encodedSSL = null;
        if (selection.sslCertChain != null) {
            X509Certificate first_cert = selection.sslCertChain[0];
            encodedSSL = new String(Base64.encodeBase64((byte[])first_cert.getEncoded()));
        }
        return new IdentityToken((ISTSResponse)stsResponse, encodedSSL);
    }

    private IElement makeClaims(ICardSpacePolicy pol, IInformationCard infocard, SelectionANDofORs selection, CertStore certStore) throws Exception {
        Element elemClaims = new Element();
        String begin = "<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">";
        String end = "</wst:Claims>";
        StringBuffer middle = new StringBuffer();
        X509Certificate[] rp_chain = selection.sslCertChain;
        List requiredClaims = pol.getRequiredClaims();
        this.makeClaimTags(requiredClaims, middle, infocard, rp_chain, certStore);
        if (pol.getOptionalClaims() != null && pol.getOptionalClaims().size() > 0) {
            List optionalClaims = pol.getOptionalClaims();
            this.makeClaimTags(optionalClaims, middle, infocard, rp_chain, certStore);
        }
        elemClaims.set((Object)(String.valueOf(begin) + middle + end));
        return elemClaims;
    }

    public void makeClaimTags(List claims, StringBuffer middle, IInformationCard infocard, X509Certificate[] rp, CertStore certStore) {
        boolean selfIssued = infocard.isSelfIssued();
        int i = 0;
        while (i < claims.size()) {
            String claim = (String)claims.get(i);
            if (selfIssued) {
                try {
                    if (PPID_CLAIM.equalsIgnoreCase(claim)) {
                        byte[] ppid = PPIDHelper.computeClaimValuePPID((IInformationCard)infocard, (X509Certificate[])rp, (CertStore)certStore);
                        if (ppid != null) {
                            String sppid = new String(Base64.encodeBase64((byte[])ppid));
                            middle.append("<ic:ClaimType Uri=\"").append(claim).append("\">").append(StringEscapeUtils.escapeXml((String)sppid)).append("</ic:ClaimType>");
                        }
                    } else {
                        ISimpleClaim sc;
                        List l;
                        IClaim c = infocard.getClaim(claim);
                        String val = null;
                        if (c instanceof ISimpleClaim && (l = (sc = (ISimpleClaim)c).getValues()).size() > 0) {
                            val = (String)l.get(0);
                        }
                        if (val != null) {
                            middle.append("<ic:ClaimType Uri=\"").append(claim).append("\">").append(StringEscapeUtils.escapeXml(val)).append("</ic:ClaimType>");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (infocard.getSupportedClaimTypesUris().contains(claim)) {
                middle.append("<ic:ClaimType Uri=\"" + claim + "\"/>");
            }
            ++i;
        }
    }

    public ConfigurationHandler getConfigurationHandler(boolean selfIssued) throws Exception {
        if (this.stsConfigurationBase == null) {
            this.stsConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        }
        if (this.stsConfigurationBase == null) {
            throw new Exception("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
        }
        String stsConfigurationFile = null;
        String stsConfigurationPersonalFile = System.getProperty("org.eclipse.higgins.sts.conf.personal.file");
        String stsConfigurationManagedFile = System.getProperty("org.eclipse.higgins.sts.conf.managed.client.file");
        stsConfigurationFile = selfIssued ? (stsConfigurationPersonalFile == null ? "PersonalConfiguration.xml" : stsConfigurationPersonalFile) : (stsConfigurationManagedFile == null ? "ClientConfiguration.xml" : stsConfigurationManagedFile);
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        configurationHandler.setConfigurationBase(this.stsConfigurationBase);
        configurationHandler.setFileName(stsConfigurationFile);
        if (!configurationHandler.configure(null)) {
            log.error((Object)"Not Initialized!");
            throw new Exception("CardspaceSelector: cannot initialize configHandler");
        }
        return configurationHandler;
    }
}

