/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.sts.api.IDisplayClaim;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;

public class DisplayToken
implements IDisplayToken {
    protected IElement element = null;
    protected org.eclipse.higgins.sts.api.IDisplayToken displayToken;
    protected HashMap map = null;

    public DisplayToken(org.eclipse.higgins.sts.api.IDisplayToken displayToken) {
        this.displayToken = displayToken;
    }

    public IClaim getClaim(String type) {
        if (this.map == null) {
            this.init();
        }
        return (IClaim)this.map.get(type);
    }

    public List getClaims() {
        if (this.map == null) {
            this.init();
        }
        return new ArrayList(this.map.values());
    }

    public Object getAs(Class objectClass) throws Exception {
        if (this.element == null) {
            this.toElement();
        }
        return this.element.getAs(objectClass);
    }

    private void toElement() {
        OMFactory f = OMAbstractFactory.getOMFactory();
        Constants constants = new Constants();
        OMNamespace ic = f.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
        OMElement omDisplayToken = f.createOMElement("DisplayToken", ic, null);
        if (this.displayToken != null) {
            List l = this.displayToken.getDisplayClaimList();
            int i = 0;
            while (i < l.size()) {
                IDisplayClaim dc = (IDisplayClaim)l.get(i);
                OMElement omDisplayClaim = f.createOMElement("DisplayClaim", ic, (OMContainer)omDisplayToken);
                omDisplayClaim.addAttribute("Uri", dc.getType().toString(), null);
                OMElement omDisplayTag = f.createOMElement("DisplayTag", ic, (OMContainer)omDisplayClaim);
                f.createOMText((OMContainer)omDisplayTag, dc.getDisplayTag());
                OMElement omDisplayValue = f.createOMElement("DisplayValue", ic, (OMContainer)omDisplayClaim);
                f.createOMText((OMContainer)omDisplayValue, dc.getDisplayValue());
                ++i;
            }
        }
        this.element = new Element();
        try {
            this.element.set((Object)omDisplayToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getSupportedClasses() {
        if (this.element == null) {
            this.toElement();
        }
        return this.element.getSupportedClasses();
    }

    private void init() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        try {
            if (this.displayToken != null) {
                List l = this.displayToken.getDisplayClaimList();
                int i = 0;
                while (i < l.size()) {
                    IDisplayClaim dc = (IDisplayClaim)l.get(i);
                    URI type = dc.getType();
                    String typeStr = type != null ? type.toString() : "";
                    boolean isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(typeStr);
                    ClaimValue c = new ClaimValue((ISimpleClaimType)new ClaimType(typeStr, dc.getDisplayTag(), null, !isPPID, !isPPID), dc.getDisplayValue());
                    this.map.put(c.getType().getType(), c);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

