/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace;

import javax.security.auth.callback.CallbackHandler;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.UnsatisfiablePolicyException;
import org.eclipse.higgins.iss.cardspace.util.AxiomUtility;
import org.eclipse.higgins.iss.cardspace.util.CardSpacePolicyHelper;
import org.eclipse.higgins.registry.IConfiguration;

public class CardSpaceSelectorFactory implements IICardSelectorFactory {
	protected static final Log log = LogFactory.getLog(CardSpaceSelectorFactory.class);
	private static final String ID = "org.eclipse.higgins.iss.cardspace";

	protected ServiceConfiguration config = new ServiceConfiguration(ID);
	
	public IPolicy parsePolicy(String policy) throws PolicyParseException {
		log.info("policy=\"" + policy + "\"");
		OMElement om = AxiomUtility.getAxiomFromString(policy);
		CardSpacePolicy pol = CardSpacePolicyHelper.fromAxiom(om);
		log.trace("policy=\"" + pol + "\"");
		return pol;
	}

	public IICardSelector getICardSelector(CallbackHandler handler,
			IPolicy policy) throws UnsatisfiablePolicyException {
		if (policy instanceof ICardSpacePolicy) {
			//return new CardSpaceSelector2(getSTSConfigurationBase(), handler, (ICardSpacePolicy) policy);
			return new CardSpaceSelector(getSTSConfigurationBase(), handler, (ICardSpacePolicy) policy);
		}
		throw new UnsatisfiablePolicyException("Invalid cardspace policy: " + policy);
	}

	public IICardSelector getICardSelector(CallbackHandler handler,
			String policy) throws PolicyParseException,
			UnsatisfiablePolicyException {
		IPolicy p = parsePolicy(policy);
		return getICardSelector(handler, p);
	}

	public String getID() {
		return ID;
	}

	public void setID(String id) throws Exception {
		throw new UnsupportedOperationException();
	}

	public IConfiguration getConfiguration() {
		// Current implementation doesn't require any configuration.
		// Just return null for now.
		return config;
	}

	public String getSTSConfigurationBase() {
		return config.getSTSConfigurationBase();
	}

}
