/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Anthony Bussani (IBM Research)
 *    Valery Kokhan - refactoring
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDisplayClaim;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;

public class DisplayToken implements IDisplayToken {
//	private static final List classes = Collections.unmodifiableList(Arrays
//			.asList(new Class[] { String.class, Element.class, OMElement.class }));

	protected IElement element = null;
	protected org.eclipse.higgins.sts.api.IDisplayToken displayToken;
	protected HashMap map = null;
	
	public DisplayToken(org.eclipse.higgins.sts.api.IDisplayToken displayToken) {
//		this.element = element;
		this.displayToken = displayToken;
	}
	
	public IClaim getClaim(String type) {
		if (map == null) {
			init();
		}
		return (IClaim) map.get(type);
	}

	public List getClaims() {
		if (map == null) {
			init();
		}
		return new ArrayList(map.values());
	}

	public Object getAs(Class objectClass) throws Exception {
		if (element == null) {
			toElement();
		}
		return element.getAs(objectClass);
	}

	private void toElement() {
		OMFactory f = OMAbstractFactory.getOMFactory();
		IConstants constants = new Constants();
		OMNamespace ic = f.createOMNamespace(constants.getIdentityNamespace().toString(), "ic");
		OMElement omDisplayToken = f.createOMElement("DisplayToken", ic, null);
		if (displayToken != null) {
			List l = displayToken.getDisplayClaimList();
			for (int i = 0; i < l.size(); i++) {
				IDisplayClaim dc = (IDisplayClaim) l.get(i);
				OMElement omDisplayClaim = f.createOMElement("DisplayClaim", ic, omDisplayToken);
				omDisplayClaim.addAttribute("Uri", dc.getType().toString(), null);
				OMElement omDisplayTag = f.createOMElement("DisplayTag", ic, omDisplayClaim);
				OMText omtDisplayTag = f.createOMText(omDisplayTag, dc.getDisplayTag());
				OMElement omDisplayValue = f.createOMElement("DisplayValue", ic, omDisplayClaim);
				OMText omtDisplayValue = f.createOMText(omDisplayValue, dc.getDisplayValue());
			}
		}
		element = new Element();
		try {
			element.set(omDisplayToken);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public List getSupportedClasses() {
		if (element == null) {
			toElement();
		}
		return element.getSupportedClasses();
	}

	private void init() {
		if (map == null) {
			map = new HashMap();
		}
		try {
			/*
			OMElement om = (OMElement) element.getAs(OMElement.class);
			IConstants constants = new Constants();
			QName qnameDisplayToken = new QName(constants.getIdentityNamespace().toString(), "DisplayToken");
			QName qnameDisplayClaim = new QName(constants.getIdentityNamespace().toString(), "DisplayClaim");
			QName qnameDisplayTag = new QName(constants.getIdentityNamespace().toString(), "DisplayTag");
			QName qnameDisplayValue = new QName(constants.getIdentityNamespace().toString(), "DisplayValue");
			QName qnameUri = new QName("Uri");
			OMElement omDisplayToken = om.getFirstChildWithName(qnameDisplayToken);
			for (Iterator itr = omDisplayToken.getChildrenWithName(qnameDisplayClaim); itr.hasNext(); ) {
				OMElement dc = (OMElement) itr.next();
				OMElement dt = dc.getFirstChildWithName(qnameDisplayTag);
				OMElement dv = dc.getFirstChildWithName(qnameDisplayValue);
				String type = dc.getAttributeValue(qnameUri);
				String dTag = dt.getText();
				String dVal = dv.getText();
				IClaim c = new ClaimValue(new ClaimType(type, dTag, null), dVal);
				map.put(type, c);
			}
			*/
			if (displayToken != null) {
				List l = displayToken.getDisplayClaimList();
				for (int i = 0; i < l.size(); i++) {
					IDisplayClaim dc = (IDisplayClaim) l.get(i);
					URI type = dc.getType();
					String typeStr = (type != null) ? type.toString() : "";
					boolean isPPID = SelfIssuedCardClaims.PPID_TYPE.equals(typeStr);
					IClaim c = new ClaimValue(new ClaimType(typeStr, dc.getDisplayTag(), null, !isPPID, !isPPID), dc.getDisplayValue());
					map.put(c.getType().getType(), c);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
