/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory;
import org.w3c.dom.Element;

public class IdentityToken implements IIdentityToken {
	private Log log = LogFactory.getLog(IdentityToken.class);

	private static final List classes = Collections.unmodifiableList(Arrays
			.asList(new Class[] { IDisplayToken.class, ISTSResponse.class, String.class,
					Element.class, OMElement.class }));
	
	private ISTSResponse response;
	private String rpCertificate;
	
	private IElement element = null;
	private IDisplayToken displayToken = null;
	
	public IdentityToken(ISTSResponse response, String rpCertificate) {
		super();
		this.response = response;
		this.rpCertificate = rpCertificate;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.iss.IIdentityToken#getAs(java.lang.Class)
	 */
	public Object getAs(Class objectClass) throws Exception {
		if (response == null) {
			return null;
		}
		if (objectClass.equals(ISTSResponse.class)) {
			return response;
		}
		if (objectClass.equals(IDisplayToken.class)) {
			if (displayToken == null) {
				displayToken = getDisplayToken();
			}
			return displayToken;
		}
		if (element == null) {
			toElement();
		}
		if (objectClass.equals(IElement.class))
			return element;
		return element.getAs(objectClass);
	}

	private synchronized IDisplayToken getDisplayToken() {
		IDisplayToken t = null;
		List listRSTR = response.getRequestSecurityTokenResponseCollection();
		if (1 == listRSTR.size())
		{
			IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTR.get(0);
			t = new DisplayToken(RSTR.getRequestedDisplayToken());
		}
		return t;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.iss.IIdentityToken#getSupportedClasses()
	 */
	public List getSupportedClasses() {
		return classes;
	}

	private synchronized void toElement() throws Exception {
		List listRSTR = response.getRequestSecurityTokenResponseCollection();
		String strEncryptedToken = null;
		IElement elemToken = null;
		OMElement omEncryptedToken = null;
		if (1 == listRSTR.size())
		{
			IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTR.get(0);
			elemToken = RSTR.getRequestedSecurityToken();
//			IElement elementDisplayToken = RSTR.getRequestedDisplayToken();
//			System.out.println("Display token: " + elementDisplayToken.getAs(String.class));
			String strToken = (String)elemToken.getAs(String.class);
			log.trace("Token: " + strToken);
			
			IConstants constants = new Constants();
			
			/// This must be done before the Token is handed off to a Browser to be POSTed to the RP.
			OMElement omRequestedSecurityToken = (OMElement)elemToken.getAs(OMElement.class);
			QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData"); 	
			QName qnameSAMLAssertion = new QName(constants.getSAML10AssertionNamespace().toString(), "Assertion"); 
			OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
			if (null != omReturnedSAMLAssertion)
			{
				if (rpCertificate != null) {
				try {
				IXMLSecurityExtension xmlSecurity = null; // (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
				if (null == xmlSecurity) {
					IConfigurableComponentFactory xmlSecurityFactory = new XMLSecurityApacheExtensionFactory();
					xmlSecurity = (IXMLSecurityExtension) xmlSecurityFactory.getSingletonInstance();
					xmlSecurity.configure(null, null, new Hashtable());
				}
				IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemToken, rpCertificate);
				OMElement omEncryptedRequestedSecurityToken = (OMElement) elemEncryptedRequestedSecurityToken.getAs(OMElement.class); 
				omEncryptedToken = omEncryptedRequestedSecurityToken.getFirstElement();
				} catch (Exception e) {
					log.error(e);
				}
				}
				else
				{
					omEncryptedToken = omReturnedSAMLAssertion;
				}
			}
			else
			{
				OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
				if (null != omReturnedEncryptedData)
				{
					omEncryptedToken = omReturnedEncryptedData;
				}
				else
				{
					log.error("Unexpected RequestedSecurityToken");
				}
			}
			strEncryptedToken = XMLHelper.toString(omEncryptedToken);
			log.trace("Encrypted Token: " + strEncryptedToken);
		}
		if (omEncryptedToken == null) {
			element = elemToken;
		} else {
			element = XMLHelper.toElement(omEncryptedToken);
		}
	}
}
