/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *    abhi shelat    - initial design
 *    Valery Kokhan  - refactoring to work with refactored STS
 *******************************************************************************/

package org.eclipse.higgins.iss.cardspace.util;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.binding.axis1x.client.MetadataExchangeServiceClientBindingFactory;
import org.eclipse.higgins.sts.binding.axis1x.client.SecurityTokenServiceClientBindingFactory;
import org.eclipse.higgins.sts.client.MetadataExchangeServiceFactory;
import org.eclipse.higgins.sts.client.SecurityTokenServiceFactory;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.InformationCardReference;
import org.eclipse.higgins.sts.common.STSResponse;

public class STSHelper {

	IInformationCard card;

	//public java.net.URI uriTokenService;

	//public java.net.URI uriMetadataService;
	private static final String PPID_CLAIM_TYPE = new Constants().getIdentityClaimPrivatePersonalIdentifier().toString();

	IElement elemClaims = new Element();

	String username;

	String password;

	X509Certificate sslCert;
	
	CertStore certStore;

	// directory that contains the configuration fieles for self signed cards
	String stsConfigurationBase;

	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper(
			STSHelper.class.getName());


	public STSHelper(String stsConfigurationBase, IInformationCard card, ICardSpacePolicy pol,
			String username, String password) throws Exception {
		this.stsConfigurationBase = stsConfigurationBase;
		this.card = card;

		/*
		this.uriTokenService = new java.net.URI(card.getIssuer());
		if (card.getMetadataAddress() != null) {
			this.uriMetadataService = new java.net.URI(card
					.getMetadataAddress());
		}
		*/

		String claims = null;
		if (card instanceof IPersonalInformationCard) {
			Hashtable claimsMap = getClaimsMap((IPersonalInformationCard)card);
			claims = personalClaimsPolicyToString(pol, claimsMap);
		}
		else
			claims = managedClaimsPolicyToString(pol);
		
//TODO remove claims logging below because this string contains claim values
log.debug("Claims: " + claims);

		elemClaims.set(claims);
		this.username = username;
		this.password = password;
		this.sslCert = null;

		String stsConfig = System.getProperty("org.eclipse.higgins.sts.conf");
		if (stsConfig != null && stsConfig.length() > 0) {
			this.stsConfigurationBase = stsConfig;
		}
		
		/*
		strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
		if (null == strConfigurationBase) {
			throw new Exception(
					"org.eclipse.higgins.sts.conf System property not found");
		}
		*/
	}

	// turn claims from policy into one string which is needed to set up
	// elemClaims
	// TODO: only temporary function
	private String managedClaimsPolicyToString(ICardSpacePolicy pol) {
		String begin = "<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">";
		String end = "</wst:Claims>";
		String middle = "";
		List requiredClaims = pol.getRequiredClaims();
		for (int i = 0; i < requiredClaims.size(); i++) {
			middle = middle
					+ claimConvertHelper((String) requiredClaims.get(i));
		}
		return begin + middle + end;
	}

	private Hashtable getClaimsMap(IPersonalInformationCard card) throws Exception {
		Hashtable ht = new Hashtable();
		Iterator itr = card.getClaims();
		while (itr.hasNext()) {
			Object obj = itr.next();
			if (obj instanceof ClaimValue == false) 
				throw new Exception("Class of claim of IPersonalInformationCard expected to be " + ClaimValue.class.getName());
			ClaimValue claim = (ClaimValue)obj;
			if (claim != null) {
				IClaimType type = claim.getType();
				if (type != null) {
					String claimType = type.getType();
					if (claimType != null) {
						String value = claim.getValue();
						if (value == null)
							value = "";
						ht.put(claimType, value);
					}
				}
				else
					log.warn("The claim type of claim is null. This claim will be skipped.");
			}
			else
				log.warn("Some of claims of the card is null. This claim will be skipped.");
		}
		return ht;
	}

	private void addPersonalClaimToBuffer(StringBuffer buf, String claimType, String claimValue) {
		buf.append("<ic:ClaimType Uri=\"");
		buf.append(claimType);
		buf.append("\">");
		buf.append(claimValue);
		buf.append("</ic:ClaimType>");
	}

	private String personalClaimsPolicyToString(ICardSpacePolicy pol, Hashtable claims) throws Exception {
		StringBuffer buffer = new StringBuffer();
		buffer.append("<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">");
		List requiredClaims = pol.getRequiredClaims();
		for (int i = 0; i < requiredClaims.size(); i++) {
			String requiredClaim = (String) requiredClaims.get(i);
			if (requiredClaim.indexOf(PPID_CLAIM_TYPE) > -1) {
				addPersonalClaimToBuffer(buffer, PPID_CLAIM_TYPE, ""); 
			}
			else {
				Enumeration types = claims.keys();
				while (types.hasMoreElements()) {
					String claimType = (String)types.nextElement();
					if (requiredClaim.indexOf(claimType) > -1) {
						String claimValue = (String)claims.get(claimType);
						addPersonalClaimToBuffer(buffer, claimType, claimValue);
						break;
					}
				}
			}
		}
		buffer.append("</wst:Claims>");
		return buffer.toString();
	}

	String claimConvertHelper(String claim) {
		return "<ic:ClaimType Uri=\"" + claim + "\"/>";
	}
	
	
	public void setX509Certificate(X509Certificate x) {
		sslCert = x;
	}
	
	public void setCertStore(CertStore cs){
		certStore = cs;
	}

	/*
	 * // taken from Mike's Test.java in sts.binding.axis1x.service/ ...
	 * /axis1x/Test.java public ISTSResponse getToken() throws Exception{
	 * 
	 * 
	 * String strBindingFactoryClass =
	 * "org.eclipse.higgins.sts.binding.axis1x.SecurityTokenServiceClientBindingFactory";
	 * TokenRequestFactory factoryRequest = new TokenRequestFactory();
	 * org.eclipse.higgins.sts.client.impl.SecurityTokenServiceFactory
	 * factorySTS = new
	 * org.eclipse.higgins.sts.client.impl.SecurityTokenServiceFactory();
	 * ISecurityTokenServiceBinding bindingSTS = null; try { bindingSTS =
	 * (ISecurityTokenServiceBinding)org.eclipse.higgins.sts.utilities.ObjectFactoryHelper.getSingletonFromFactory
	 * (strBindingFactoryClass); } catch (Exception e) {
	 * org.eclipse.higgins.sts.utilities.ExceptionHelper.Log (log, e); //return
	 * "Error"; throw e; } // java.net.URI uriTokenService = null; //
	 * java.net.URI uriMetadataService = null; //
	 * org.eclipse.higgins.sts.IElement elemClaims = new
	 * org.eclipse.higgins.sts.impl.Element(); // try // { // uriTokenService =
	 * new
	 * java.net.URI("https://paulazpro.watson.ibm.com/TokenService/services/Trust"); //
	 * uriMetadataService = new
	 * java.net.URI("https://paulazpro.watson.ibm.com/TokenService/services/MetadataUsernameToken"); //
	 * elemClaims.set("<wst:Claims
	 * xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"
	 * xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\"
	 * wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType
	 * Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType
	 * Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/></wst:Claims>"); // } //
	 * catch (Exception e) // { //
	 * org.eclipse.higgins.sts.utilities.ExceptionHelper.Log // (log, // e); //
	 * return "Error"; // } java.util.Map mapConfiguration = new
	 * java.util.Hashtable(); System.out.println( "uriTokenService: " +
	 * uriTokenService ); System.out.println( "uriMetadataService: " +
	 * uriMetadataService ); mapConfiguration.put("TokenServiceURI",
	 * uriTokenService); mapConfiguration.put("MetadataServiceURI",
	 * uriMetadataService); bindingSTS.initialize();
	 * bindingSTS.configure(mapConfiguration); ISecurityTokenService sts =
	 * (ISecurityTokenService)factorySTS.getSingletonInstance();
	 * sts.initialize(); sts.configure(bindingSTS, mapConfiguration); IConstants
	 * constants = new Constants(); //
	 * org.eclipse.higgins.sts.client.IInformationCard card = new TestCard();
	 * IMEXResponse mexResponse = sts.getMetadata(card, mapConfiguration,
	 * constants); if (null != mexResponse.getFault()) {
	 * System.err.println("Returning MEX Fault"); log.trace("Returning MEX
	 * Fault"); IFault fault = mexResponse.getFault();
	 * System.err.println("Returning MEX Fault: " + fault.getDetail()); //
	 * return "MEX Fault"; throw new Exception( "MEX Fault"); } ISTSResponse
	 * stsResponse = new STSResponse(); java.net.URI uri =
	 * java.net.URI.create("https://bordighera:8443"); ISTSRequest stsRequest =
	 * factoryRequest.createRequest (uri, sslCert, mexResponse.getMetadata(),//
	 * mex uriTokenService,
	 * java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), card,
	 * elemClaims, username , password ); sts.invoke(stsRequest, stsResponse,
	 * mapConfiguration, constants); sts.destroy(); bindingSTS.destroy(); if
	 * (null != stsResponse.getFault()) { System.err.println("Returning STS
	 * Fault"); log.trace("Returning STS Fault"); // return "STS Fault"; throw
	 * new Exception( "STS Fault"); } System.out.println("token successfully
	 * generated !!!!"); // return "Success"; return stsResponse;
	 * 
	 * ISTSResponse r = null; return r; }
	 */
	
	public ISTSResponse getToken() throws Exception {
		if( card.isSelfIssued() ){
			return getToken_SelfSignedCard();
		}else{
			return getToken_ManagedCard();
		}
	}

	// TODO update according to TestManaged
	public ISTSResponse getToken_ManagedCard() throws Exception {
		IManagedInformationCard mCard = (IManagedInformationCard)card;
		IConfigurableComponentFactory bindingFactorySTS = new SecurityTokenServiceClientBindingFactory();
		IConfigurableComponentFactory bindingFactoryMEX = new MetadataExchangeServiceClientBindingFactory();
		ISecurityTokenService bindingSTS = (ISecurityTokenService) bindingFactorySTS
				.getSingletonInstance();
		IMetadataExchangeService bindingMEX = (IMetadataExchangeService) bindingFactoryMEX
				.getSingletonInstance();
		ISecurityTokenService sts = null;
		IMetadataExchangeService mex = null;
		Map mapGlobalSettings = new java.util.Hashtable();
		
		// Get token service uri and metadata service uri from i-card
		// TODO If token service list contains more then one endpoint reference iterate 
		// through them to obtain token instead of simple implementation below
		List services = mCard.getTokenServices();
		ITokenService service = (ITokenService) services.get(0);
		IEndpointReference ref = service.getEndpointReference();
		
		URI uriTokenService = ref.getAddress();
		URI uriMetadataService = ref.getMetadataAddress();
		
		// URI uriTokenService =
		// URI.create("http://localhost:8080/TokenService/services/Trust");
		// URI uriMetadataService =
		// URI.create("http://localhost:8080/TokenService/services/MetadataUsernameToken");
		mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
		log.error("uri metadata service: " + uriMetadataService);
		mapGlobalSettings.put("MetadataServiceURI", uriMetadataService);
		
		mapGlobalSettings.put("SecurityTokenServiceBinding", bindingSTS);
		mapGlobalSettings.put("MetadataExchangeServiceBinding", bindingMEX);

		bindingSTS.configure(mapGlobalSettings, null, null, null, null);
		SecurityTokenServiceFactory factorySTS = new SecurityTokenServiceFactory();
		sts = (ISecurityTokenService) factorySTS.getSingletonInstance();
		sts.configure(mapGlobalSettings, null, null, null, null);
		bindingMEX.configure(mapGlobalSettings, null, null, null, null);
		MetadataExchangeServiceFactory factoryMEX = new MetadataExchangeServiceFactory();
		mex = (IMetadataExchangeService) factoryMEX.getSingletonInstance();
		mex.configure(mapGlobalSettings, null, null, null, null);

		// Create a Card
		// final org.eclipse.higgins.sts.client.samples.IInformationCard card =
		// new TestCard();

		final IInformationCardReference informationCardReference = new InformationCardReference();
		informationCardReference.setCardId(java.net.URI.create(mCard.getID()));
		informationCardReference.setCardVersion(mCard.getVersion());

		// Get the Metadata
		IConstants constants = new Constants();

		/*
		 * IMEXResponse mexResponse = mex.getMetadata (mapGlobalSettings, null,
		 * null, null, constants, uriMetadataService); if (null !=
		 * mexResponse.getFault()) { System.err.println("Returning MEX Fault");
		 * this.log.trace("Returning MEX Fault"); IFault fault =
		 * mexResponse.getFault(); System.err.println("Returning MEX Fault: " +
		 * fault.getDetail()); throw new Exception("Returning MEX Fault: " +
		 * fault.getDetail()); }
		 */

		// Create a Request
		TokenRequestFactory factoryRequest = new TokenRequestFactory();
		// IElement elemClaims = new Element();
		// elemClaims.set("<wst:Claims
		// xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"
		// xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\"
		// wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType
		// Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType
		// Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/><ic:ClaimType
		// Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"/></wst:Claims>");

		ISTSResponse stsResponse = new STSResponse();
		ISTSRequest stsRequest = factoryRequest.createManagedRequest(null,
				new X509Certificate[] {sslCert},
				certStore,
				uriTokenService, 
				java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"),
				mCard, elemClaims, username, password);

		// Invoke the STS
		sts.invoke(mapGlobalSettings, null, null, null, constants, stsRequest,
				stsResponse);
		if (null != stsResponse.getFault()) {
			log.error("Returning STS Fault");
			this.log.trace("Returning STS Fault");
			IFault fault = stsResponse.getFault();
			log.error("Returning STS Fault: " + fault.getDetail());
			throw new Exception("Returning STS Fault: " + fault.getDetail());
		}

		return stsResponse;
	}

	// strConfiguarteBase has to be set.
	// for example to "/home/bas/eclipse/config_selfsigned"
	public ISTSResponse getToken_SelfSignedCard() throws Exception {
		IPersonalInformationCard pCard = (IPersonalInformationCard)card;

		// Setup STS (No Binding)
		java.util.Map mapGlobalSettings = null;
		final org.eclipse.higgins.configuration.xml.ConfigurationHandler configurationHandler = new org.eclipse.higgins.configuration.xml.ConfigurationHandler();
		if (null == stsConfigurationBase) {
			throw new Exception("Directory with System properties not set");
		}
		configurationHandler.setConfigurationBase(stsConfigurationBase);
		configurationHandler.setFileName("PersonalConfiguration.xml");
		boolean bInitialized = configurationHandler.configure(null);
		if (!bInitialized) {
			this.log.error("Not Initialized!");
			throw new Exception("Not initialized!");
		}
		mapGlobalSettings = configurationHandler.getSettings();
		final ISecurityTokenService sts = (ISecurityTokenService) mapGlobalSettings
				.get("SecurityTokenService");

		final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = new org.eclipse.higgins.sts.common.InformationCardReference();
		informationCardReference.setCardId(java.net.URI.create(pCard.getID()));
		informationCardReference.setCardVersion(pCard.getVersion());

		// Create Request
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		final TokenRequestFactory factoryRequest = new TokenRequestFactory();

		final ISTSResponse stsResponse = new STSResponse();
		/*
		final org.eclipse.higgins.sts.api.ISTSRequest stsRequest = factoryRequest
				.createRequest(null, null, uriTokenService, java.net.URI
						.create("urn:oasis:names:tc:SAML:1.0:assertion"),
						informationCardReference, elemClaims, username,
						password);
		*/

		final org.eclipse.higgins.sts.api.ISTSRequest stsRequest = factoryRequest
				.createPersonalRequest(null, 
						new X509Certificate[] {sslCert}, 
						certStore,
						java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"),
						pCard, elemClaims);

		// Invoke the STS
		sts.invoke(mapGlobalSettings, "SecurityTokenService", null, null,
				constants, stsRequest, stsResponse);

		if (null != stsResponse.getFault()) {
			log.error("Returning STS Fault");
			log.error(stsResponse.getFault().getDetail());
			throw new Exception("STS Fault");
		}

		return stsResponse;

	}

}
