/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss;

import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.UnsatisfiablePolicyException;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.SecurityRegistryExtension;

public class ICardSelectorService
extends HigginsRegistry {
    protected static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$ICardSelectorService == null ? (class$org$eclipse$higgins$iss$ICardSelectorService = ICardSelectorService.class$("org.eclipse.higgins.iss.ICardSelectorService")) : class$org$eclipse$higgins$iss$ICardSelectorService));
    protected static ICardSelectorService instance = null;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$ICardSelectorService;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$IICardSelectorFactory;

    protected ICardSelectorService() {
        super(class$org$eclipse$higgins$iss$IICardSelectorFactory == null ? (class$org$eclipse$higgins$iss$IICardSelectorFactory = ICardSelectorService.class$("org.eclipse.higgins.iss.IICardSelectorFactory")) : class$org$eclipse$higgins$iss$IICardSelectorFactory);
        log.info((Object)"Constructor");
        this.initialize();
    }

    public ICardSelectorService(String configPath) {
        super(class$org$eclipse$higgins$iss$IICardSelectorFactory == null ? (class$org$eclipse$higgins$iss$IICardSelectorFactory = ICardSelectorService.class$("org.eclipse.higgins.iss.IICardSelectorFactory")) : class$org$eclipse$higgins$iss$IICardSelectorFactory, configPath);
        log.info((Object)("Config Path is " + configPath));
        this.initialize();
    }

    private void initialize() {
        this.addExtension((IRegistryExtension)new IIORegistryExtension(class$org$eclipse$higgins$iss$IICardSelectorFactory == null ? (class$org$eclipse$higgins$iss$IICardSelectorFactory = ICardSelectorService.class$("org.eclipse.higgins.iss.IICardSelectorFactory")) : class$org$eclipse$higgins$iss$IICardSelectorFactory));
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension(class$org$eclipse$higgins$iss$IICardSelectorFactory == null ? (class$org$eclipse$higgins$iss$IICardSelectorFactory = ICardSelectorService.class$("org.eclipse.higgins.iss.IICardSelectorFactory")) : class$org$eclipse$higgins$iss$IICardSelectorFactory));
        try {
            Class<?> c = Class.forName("org.eclipse.higgins.iss.plugin.ICardSelectorRegistryExtension");
            IRegistryExtension e = (IRegistryExtension)c.newInstance();
            this.addExtension(e);
        }
        catch (ClassNotFoundException e) {
            log.info((Object)e);
        }
        catch (Throwable e) {
            log.info((Object)e);
        }
        this.loadProviders();
    }

    public Iterator getICardSelectorFactories() {
        return this.getServiceProviders();
    }

    public IICardSelectorFactory getICardSelectorFactory(String extID) {
        if (extID == null) {
            throw new IllegalArgumentException("id == null!");
        }
        return (IICardSelectorFactory)this.getServiceProvider(extID);
    }

    protected String getConfigFolder() {
        return ".iss";
    }

    public static synchronized ICardSelectorService getInstance() {
        if (instance == null) {
            instance = new ICardSelectorService();
        }
        return instance;
    }

    public IPolicy parsePolicy(String policy) throws PolicyParseException {
        log.info((Object)"ICardSelectorService::parsePolicy(String policy)");
        log.info((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            log.trace((Object)("Current IICardSelectorFactory = " + f));
            try {
                IPolicy pol = f.parsePolicy(policy);
                if (pol == null) continue;
                log.debug((Object)("Parsed policy: " + pol));
                return pol;
            }
            catch (PolicyParseException e) {
                log.error((Object)e);
            }
        }
        throw new PolicyParseException("Unable to find proper policy parser.");
    }

    public IICardSelector getICardSelector(CallbackHandler handler, IPolicy policy) throws UnsatisfiablePolicyException {
        log.info((Object)"ICardSelectorService::getICardSelector(CallbackHandler handler, IPolicy policy)");
        log.info((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            try {
                IICardSelector selector = f.getICardSelector(handler, policy);
                if (selector == null) continue;
                log.info((Object)("I-Card Selector found: " + selector));
                return selector;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        throw new UnsatisfiablePolicyException("Unable to find proper i-card selector.");
    }

    public IICardSelector getICardSelector(CallbackHandler handler, String policy) throws PolicyParseException, UnsatisfiablePolicyException {
        log.info((Object)"ICardSelectorService::getICardSelector(CallbackHandler handler, String policy)");
        log.info((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            log.trace((Object)("Current IICardSelectorFactory = " + f));
            try {
                IICardSelector selector = f.getICardSelector(handler, policy);
                if (selector == null) continue;
                log.info((Object)("I-Card Selector found: " + selector));
                return selector;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        throw new PolicyParseException("Unable to find proper policy parser.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

