/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss;

import javax.security.auth.callback.CallbackHandler;

import org.eclipse.higgins.icard.IPolicy;

public interface IICardSelector {

	/**
	 * Gets policy used by this selector to filter suitable i-cards.
	 * 
	 * @see org.eclipse.higgins.icard.ICardProvider#getICards(CallbackHandler,
	 *      IPolicy)
	 */
	public IPolicy getPolicy();

	/**
	 * Gets callback handler used by this selector to identify the user whose
	 * i-cards were requested.
	 * 
	 * @see org.eclipse.higgins.icard.ICardProvider#getICards(CallbackHandler,
	 *      IPolicy)
	 */
	public CallbackHandler getCallbackHandler();

	/**
	 * Gathers I-Cards from all available I-Card Providers in the I-Card
	 * Registry and returns UserChoiceTree object containing all suitable.
	 * 
	 * @see org.eclipse.higgins.icard.ICard
	 * @see org.eclipse.higgins.icard.ICardProvider
	 * @see org.eclipse.higgins.icard.registry.ICardRegistry
	 */
	public UserChoiceTree getUserChoice() throws Exception;

	public IIdentityToken getIdentityToken(SelectionANDofORs selection) throws Exception;
}
