/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *******************************************************************************/


package org.eclipse.higgins.iss;

import org.eclipse.higgins.icard.ICard;

public class CredentialContainer {
	
	public ICard credential;
	public String key;
	
	public CredentialContainer( ICard credential, String key ){
		this.credential = credential;
		this.key = key;
	}
	
	public String toString(){
		return "[ Credential: " + this.credential +
		       "\nKey: " + key;
	}
	
	public String getKey() { return key; }
	public ICard getCredential() { return credential; }
	public String getName() { return credential.getName(); } 
	public String getDescription() { return credential.getDescription(); }

	
}
