/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.iss;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class UserChoiceTree {
	
	// can be either AND or OR
	public String connective = "unknown";
	
	// elements are of the type UserChoiceTree or UCTelm
	public List elms = new ArrayList();
	
	public boolean policyIsSatisfied = false;

	public void add( Object ob) {
		elms.add( ob );
	}
	
	public String toString() {
		return "Connective:" + this.connective + ";\n" + "Elements:\n"
				+ elms.toString() + "; \n" + "IsSatisfying policy:\n"
				+ policyIsSatisfied;
	}
	
	public ListIterator getListIterator() {
		return elms.listIterator();
	}
}
