/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss;

import java.util.List;

public interface IToken {
	/**
	 * Gets the List of the Classes supported by the underlying implementation
	 * 
	 * @return the List of the Classes supported by the underlying
	 *         implementation
	 */
	public List getSupportedClasses();

	/**
	 * Gets a clone of the contained object, converted to the Class specified by
	 * objectClass
	 * 
	 * @param objectClass
	 *            the class of the object to be returned
	 * @return a clone of the contained object, converted to the Class specified
	 *         by objectClass
	 * @throws Exception
	 *             when the Class specified by objectClass is not supported by
	 *             the underlying implementation
	 */
	public Object getAs(Class objectClass) throws Exception;
}
