/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *******************************************************************************/


package org.eclipse.higgins.iss;

import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.icard.IPolicy;




public class UCTelm {
	IPolicy atPol;
	
	// contains elements of type credentialContainer
	public List credentialContainers;
	
	public UCTelm( IPolicy atPol, List credCons  ){
		this.atPol = atPol;
		this.credentialContainers = credCons;
	}
	
	public String toString(){
		String ret = "[ Atomic Policy:\n" + atPol.toString()  +
		             "Credentials:\n" + credentialContainers.toString() + 
		             "\nisSatisfied: " + this.policyIsSatisfied() + " ]";
		return ret;
	}
	
	public boolean policyIsSatisfied(){
		if( credentialContainers.size() > 0 ){
			return true;
		}else{
			return false;
		}
	}
	
	public IPolicy getAtom() { return atPol; }
	public Iterator getCredsIterator() { return credentialContainers.iterator(); }
	
}
