/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *******************************************************************************/


package org.eclipse.higgins.iss;

import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IPolicy;


public class SelectionANDofORsElm {
	
	// data base identifier of credential
    String uuid;
    int index_AND;
    int index_OR;
    
    ICard credential;
    IPolicy atPol;

    public String getUUID() { return uuid; }
    public int getIndexAND() { return index_AND; }
    public int getIndexOR() { return index_OR; }
    public IPolicy getAtom() { return atPol; }
    public void setAtom(IPolicy a) { atPol = a; }
    
    public void setCredential(ICard c) { credential = c; }
    public ICard getCredential() { return credential; }
    
    public SelectionANDofORsElm( String uuid, int i, int j){
    	this.uuid = uuid;
    	this.index_AND = i;
    	this.index_OR = j;
    }
	
    // test whether the atomic policy matches the credential
    public boolean atomicPolicyMatchesCredential(){
    	if ( (credential == null)  || (atPol == null) ){
    		return false;
    	}else{
    		return atPol.isSatisfiedBy(credential);
    	}
    }
	
	
	
}
