/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss;

import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.UnsatisfiablePolicyException;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.SecurityRegistryExtension;

public class ICardSelectorService
extends HigginsRegistry {
    protected static Log log;
    protected static ICardSelectorService instance;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.iss.ICardSelectorService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        instance = null;
    }

    protected ICardSelectorService() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.iss.IICardSelectorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        log.trace((Object)"Constructor");
        this.initialize();
    }

    public ICardSelectorService(String configPath) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.iss.IICardSelectorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz, configPath);
        log.trace((Object)("Config Path is " + configPath));
        this.initialize();
    }

    private void initialize() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.iss.IICardSelectorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new IIORegistryExtension((Class)clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.higgins.iss.IICardSelectorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension((Class)clazz2));
        try {
            Class<?> c = Class.forName("org.eclipse.higgins.iss.plugin.ICardSelectorRegistryExtension");
            IRegistryExtension e = (IRegistryExtension)c.newInstance();
            this.addExtension(e);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)e);
        }
        catch (Throwable e) {
            log.warn((Object)e);
        }
        this.loadProviders();
    }

    public Iterator getICardSelectorFactories() {
        return this.getServiceProviders();
    }

    public IICardSelectorFactory getICardSelectorFactory(String extID) {
        if (extID == null) {
            throw new IllegalArgumentException("id == null!");
        }
        return (IICardSelectorFactory)this.getServiceProvider(extID);
    }

    protected String getConfigFolder() {
        return ".iss";
    }

    public static synchronized ICardSelectorService getInstance() {
        if (instance == null) {
            instance = new ICardSelectorService();
        }
        return instance;
    }

    public IPolicy parsePolicy(String policy) throws PolicyParseException {
        log.trace((Object)"ICardSelectorService::parsePolicy(String policy)");
        log.trace((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            log.trace((Object)("Current IICardSelectorFactory = " + f));
            try {
                IPolicy pol = f.parsePolicy(policy);
                if (pol == null) continue;
                log.debug((Object)("Parsed policy: " + pol));
                return pol;
            }
            catch (PolicyParseException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        throw new PolicyParseException("Unable to find proper policy parser.");
    }

    public IICardSelector getICardSelector(CallbackHandler handler, IPolicy policy) throws UnsatisfiablePolicyException {
        log.trace((Object)"ICardSelectorService::getICardSelector(CallbackHandler handler, IPolicy policy)");
        log.trace((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            try {
                IICardSelector selector = f.getICardSelector(handler, policy);
                if (selector == null) continue;
                log.trace((Object)("I-Card Selector found: " + selector));
                return selector;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        throw new UnsatisfiablePolicyException("Unable to find proper i-card selector.");
    }

    public IICardSelector getICardSelector(CallbackHandler handler, String policy) throws PolicyParseException, UnsatisfiablePolicyException {
        log.trace((Object)"ICardSelectorService::getICardSelector(CallbackHandler handler, String policy)");
        log.trace((Object)("policy: " + policy));
        Iterator itr = this.getICardSelectorFactories();
        while (itr.hasNext()) {
            IICardSelectorFactory f = (IICardSelectorFactory)itr.next();
            log.trace((Object)("Current IICardSelectorFactory = " + f));
            try {
                IICardSelector selector = f.getICardSelector(handler, policy);
                if (selector == null) continue;
                log.trace((Object)("I-Card Selector found: " + selector));
                return selector;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        throw new PolicyParseException("Unable to find proper policy parser.");
    }
}

