/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *    abhi shelat    - initial design
 *******************************************************************************/

package org.eclipse.higgins.iss;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

import org.eclipse.higgins.icard.auth.ICredential;
public class SelectionANDofORs {
	
	ArrayList selectionElms = new ArrayList();
	
	protected ICredential credential;
	
	public String username;
	public String password;
	
	public String action;
	
	public String idemix_credential_db_uri;
	public String cardspace_credential_db_uri;
	
	public String publickey_db_uri;

	public boolean optionalClaims = false;
	
	public X509Certificate[] sslCertChain;
	
	public SelectionANDofORs() {
		selectionElms = new ArrayList();
	}
	
	public void add(SelectionANDofORsElm e) {
		selectionElms.add(e);
	}
	
	public boolean isEmpty() { return selectionElms.isEmpty(); }
	
	public ArrayList getElements() { return selectionElms; }

	public ICredential getCredential() {
		return credential;
	}

	public void setCredential(ICredential credential) {
		this.credential = credential;
	}
}
