/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss;

import java.util.List;

import org.eclipse.higgins.icard.IClaim;

public interface IDisplayToken extends IToken {
	/**
	 * Return all claims available for display purposes.
	 * 
	 * @return A List of {@link IClaim}s.
	 */
	public List getClaims();

	/**
	 * Returns the specified claim from this object.
	 * 
	 * @param type
	 *            the identifier of the claim to be returned.
	 * @return an {@link IClaim} or {@code null} if none exits.
	 */
	public IClaim getClaim(String type);
	
}
