/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss.util;

import java.io.FileInputStream;
import java.io.StringReader;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxiomUtility {
	
	private static final Log log = LogFactory.getLog(AxiomUtility.class);
	
	public static final String uids_string_prefix = "<wst:UseKey xmlns:wst = \"http://schemas.xmlsoap.org/ws/2005/05/identity\">";
	public static final String uids_string_postfix = "</wst:UseKey>";
	
	private static org.apache.axiom.om.OMFactory omFactory = org.apache.axiom.om.OMAbstractFactory.getOMFactory();
	
	public static OMElement getAxiomFromString(String strElement) {
        if (strElement == null) return null;
        
        StAXOMBuilder builder = null;
        try {
            javax.xml.stream.XMLInputFactory f = javax.xml.stream.XMLInputFactory
                    .newInstance();
            XMLStreamReader sr = f.createXMLStreamReader(new StringReader(
                    strElement));
            builder = new StAXOMBuilder(sr);
        } catch (XMLStreamException e) {
        	log.error(e, e);
            return null;
        }
        OMElement documentElement = builder.getDocumentElement();
        
        return documentElement;

    }
	
	public static String readTextFile(String fullPathFilename) {
		String content = null;
		try {
			FileInputStream fis = new FileInputStream(fullPathFilename);
			int x = fis.available();
			byte b[] = new byte[x];
			fis.read(b);
			content = new String(b);
			return content;
		} catch (Exception e) {
			log.error(e, e);
			return "";
		}
	}

	public static org.apache.axiom.om.OMFactory getOmFactory() {
		return omFactory;
	}
	
	public static void addAttriubte_save( OMElement om, String name , String att  ){
		if ( att!=null ){
			om.addAttribute( name, att, null );
		}
	}

	public static void addChild_save( OMElement om, Object obj  ){
		if ( obj!=null ){
			//om.addChild( obj.toAxiom());
					}
	}
	

}
