/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.keystore.common.X509.AccessDescription;
import org.eclipse.higgins.keystore.common.X509.Extension;
import org.eclipse.higgins.keystore.common.X509.ObjectIdentifier;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class AuthorityInformationAccessExtension
extends Extension {
    private List accessDescriptions = new ArrayList();

    public List getAccessDescriptions() {
        return this.accessDescriptions;
    }

    public void setAccessDescriptions(List accessDescription) {
        this.accessDescriptions = accessDescription;
    }

    public AuthorityInformationAccessExtension(byte[] extensionValue, boolean critical) {
        this.critical = critical;
        this.extensionValue = extensionValue;
        try {
            this.extensionId = new ObjectIdentifier("1.3.6.1.5.5.7.1.1");
            Asn1Node node = Asn1Node.getInstance(extensionValue);
            if (node.getTag() == 4) {
                node = Asn1Node.getInstance(node.getValue());
            }
            if (node.getTag() == 48 || node.getTag() == 48) {
                this.parse(node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(Asn1Node node) throws CertificateParsingException {
        if (!node.getCollection().isEmpty()) {
            Iterator iter = node.getCollection().iterator();
            while (iter.hasNext()) {
                this.accessDescriptions.add(new AccessDescription((Asn1Node)iter.next()));
            }
        }
    }

    public String toString() {
        if (this.accessDescriptions == null) {
            return "";
        }
        StringBuffer stringbuilder = new StringBuffer(super.toString());
        stringbuilder.append("AuthorityInfoAccess [\n");
        Iterator iterator = this.accessDescriptions.iterator();
        while (iterator.hasNext()) {
            AccessDescription description = (AccessDescription)iterator.next();
            stringbuilder.append(description.toString());
        }
        stringbuilder.append("]\n");
        return stringbuilder.toString();
    }
}

