/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.common.X509;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateParsingException;
import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class URIName {
    private URI uri;

    public URIName(Asn1Node node) throws CertificateParsingException {
        try {
            this.initialize(node.getValueAsIA5String());
        }
        catch (UnsupportedEncodingException e) {
            throw (CertificateParsingException)new CertificateParsingException(e.toString()).initCause(e);
        }
    }

    public URIName(String s) throws CertificateParsingException {
        this.initialize(s);
    }

    private void initialize(String s) throws CertificateParsingException {
        try {
            this.uri = new URI(s);
        }
        catch (URISyntaxException urisyntaxexception) {
            throw (CertificateParsingException)new CertificateParsingException(urisyntaxexception.toString()).initCause(urisyntaxexception);
        }
    }

    public String toString() {
        return "URIName: " + this.uri.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIName)) {
            return false;
        }
        URIName uriname = (URIName)obj;
        return this.uri.equals(uriname.getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

